/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.expression.Value;
import com.nestor.interpret.jbasic.lang.Function;
import com.nestor.interpret.jbasic.lang.Parameter;
import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.UndeclaredIdentifierException;
import com.nestor.interpret.jbasic.parse.SyntaxTokens;
import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Parser;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.type.DATA;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FunctionValueParser
implements Parser<Value> {
    private final ParseContext context;

    FunctionValueParser(ParseContext context) {
        this.context = context;
    }

    @Override
    public String describe() {
        return "function call";
    }

    @Override
    public Value parse(Scanner scanner, ParseEnv env) throws ParseException {
        String identifier = scanner.match(SyntaxTokens.IDENTIFIER);
        if (identifier == null) {
            return null;
        }
        if (this.context.moduleBuilder().containsFunction(identifier)) {
            Function function;
            scanner.advance();
            try {
                function = this.context.moduleBuilder().getFunction(identifier);
            }
            catch (UndeclaredIdentifierException e) {
                throw scanner.parseFailure(e);
            }
            List<Parameter> parameters = function.getParameters();
            List<Value<? extends DATA>> arguments = this.context.parseHelper().requireParameterValueList(scanner, parameters, false);
            return function.createCall((List)arguments);
        }
        return null;
    }
}

