/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.jbasic.lang.DeclarationException;
import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.RedeclarationException;
import com.nestor.interpret.jbasic.parse.SyntaxTokens;
import com.nestor.interpret.jbasic.parse.VariableList;
import com.nestor.interpret.jbasic.parse.VariableListFilter;
import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Parser;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.token.StandardTokens;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.TYPE;
import com.nestor.shared.Description;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VariableListParser
implements Parser<VariableList> {
    private final ParseContext context;
    private final VariableListFilter filter;

    public VariableListParser(ParseContext context, VariableListFilter filter) {
        this.context = context;
        this.filter = filter;
    }

    @Override
    public String describe() {
        return "variable list parser";
    }

    @Override
    public VariableList parse(Scanner scanner, ParseEnv env) throws ParseException {
        LinkedHashMap<String, TYPE<? extends DATA>> vars = new LinkedHashMap<String, TYPE<? extends DATA>>();
        boolean comma = false;
        do {
            String identifier;
            if (comma || !comma && !this.filter.acceptNoVariablesChained()) {
                identifier = scanner.required(SyntaxTokens.IDENTIFIER);
            } else {
                identifier = scanner.matchAdvance(SyntaxTokens.IDENTIFIER);
                if (identifier == null) break;
            }
            TYPE<? extends DATA> variableType = this.context.parseHelper().requireTypeDeclaration(scanner);
            Description identified = this.context.identify(identifier);
            if (identified != null && !this.context.moduleBuilder().containsVariable(identifier) && !this.context.stack().containsVariable(identifier)) {
                throw scanner.parseFailure(new RedeclarationException(identifier, identified));
            }
            try {
                this.filter.verifyChained(this.context, identifier, variableType);
            }
            catch (DeclarationException e) {
                throw scanner.parseFailure(e);
            }
            vars.put(identifier, variableType);
        } while (comma = scanner.matchAdvance(StandardTokens.COMMA) != null);
        return new VariableList(vars);
    }
}

