/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.profile.qbasic.parse;

import com.nestor.interpret.expression.Value;
import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Parser;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.token.RegexToken;
import com.nestor.interpret.type.DOUBLE;
import com.nestor.interpret.type.INTEGER;
import com.nestor.interpret.type.NUMBER;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QNumberValueParser
implements Parser<Value<? extends NUMBER>> {
    public static final QNumberValueParser PARSER = new QNumberValueParser();
    public static final RegexToken QDOUBLE_TOKEN = new RegexToken("\\d*\\.\\d+#?");
    public static final RegexToken QINTEGER_TOKEN = new RegexToken("&?H?\\d+[#&]?");

    private QNumberValueParser() {
    }

    @Override
    public String describe() {
        return "number";
    }

    @Override
    public NUMBER<? extends NUMBER> parse(Scanner scanner, ParseEnv env) throws ParseException {
        String lex = scanner.matchAdvance(QINTEGER_TOKEN);
        if (lex != null) {
            if (lex.startsWith("&")) {
                lex = lex.substring(1);
            }
            if (lex.endsWith("&") || lex.endsWith("#")) {
                lex = lex.substring(0, lex.length() - 1);
            }
            if (lex.startsWith("H")) {
                return new INTEGER(Integer.parseInt(lex.substring(1), 16));
            }
            return new INTEGER(Integer.parseInt(lex));
        }
        lex = scanner.matchAdvance(QDOUBLE_TOKEN);
        if (lex != null) {
            if (lex.startsWith(".")) {
                lex = "0" + lex;
            }
            if (lex.endsWith("#")) {
                lex = lex.substring(0, lex.length() - 1);
            }
            return new DOUBLE(Double.parseDouble(lex));
        }
        return null;
    }
}

