/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.statement;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.jbasic.lang.RuntimeContext;
import com.nestor.interpret.jbasic.lang.Variable;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.statement.ReturnCode;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.type.ARRAY_TYPE;
import com.nestor.interpret.type.DATA;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedimStatement
extends Statement {
    private static final long serialVersionUID = 5123221656866838110L;
    private final String name;
    private final ARRAY_TYPE<? extends DATA> redimType;

    public RedimStatement(String name, ARRAY_TYPE<? extends DATA> variableType) {
        this.name = name;
        this.redimType = variableType;
    }

    @Override
    public String describe() {
        return StatementTokens.REDIM + " " + this.name + " AS " + this.redimType.describe();
    }

    @Override
    protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
        Variable var = null;
        var = context.stack().containsVariable(this.name) ? context.stack().getVariable(this.name) : context.module().getVariable(this.name);
        ARRAY_TYPE varType = (ARRAY_TYPE)var.getValueType();
        varType.redim(this.redimType.getDimensions());
        var.setValue(this.redimType.newInstance());
        return ReturnCode.SUCCESS;
    }
}

