/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.parse;

import com.nestor.interpret.parse.Match;
import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Parser;
import com.nestor.interpret.parse.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RefinedParser<M extends Match>
implements Parser<M> {
    private final Class<M> matchClass;
    private Parser subparser;

    public RefinedParser(Class<M> matchClass, Parser subparser) {
        this.matchClass = matchClass;
        this.subparser = subparser;
    }

    protected final M castIfMatchCompatible(Match match) {
        if (match == null) {
            return null;
        }
        if (this.matchClass.isAssignableFrom(match.getClass())) {
            return (M)match;
        }
        return null;
    }

    protected final void changeSubparser(Parser subparser1) {
        this.subparser = subparser1;
    }

    public final Class<M> getMatchClass() {
        return this.matchClass;
    }

    protected final Match matchAny(Scanner scanner, ParseEnv env) throws ParseException {
        return this.subparser.parse(scanner, env);
    }

    protected final M seekCompatibleMatch(Scanner scanner, ParseEnv env) throws ParseException {
        Match match = this.matchAny(scanner, env);
        M mMatch = this.castIfMatchCompatible(match);
        if (mMatch == null) {
            return null;
        }
        return mMatch;
    }

    @Deprecated
    protected final M requireCompatibleMatch(Scanner scanner, ParseEnv env) throws ParseException {
        ParseException failure = scanner.expected(this.matchClass.getSimpleName());
        Match match = this.matchAny(scanner, env);
        M mMatch = this.castIfMatchCompatible(match);
        if (mMatch == null) {
            throw failure;
        }
        return mMatch;
    }
}

