/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.parse;

import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.token.Token;
import com.nestor.interpret.token.TokenContainer;
import com.nestor.shared.Description;

public abstract class Scanner {
    protected static final Lexeme BEGIN_LEXEME = new Lexeme(null, "");
    private Lexeme lastLexeme = BEGIN_LEXEME;
    private final TokenContainer tokens;
    private final ParseEnv env;

    public Scanner(ParseEnv env, TokenContainer tokens) {
        this.tokens = tokens;
        this.env = env;
    }

    public abstract Token advance() throws ParseException;

    private void checkToken(Token token) {
        if (!this.tokens.contains(token)) {
            String string = "unknown token: " + token + "(" + token.describe() + ")";
            throw new IllegalArgumentException(string);
        }
    }

    public final ParseException expected(Description expectation) {
        return new ParseException(expectation, this.getCurrentPositionDescription());
    }

    public final ParseException expected(String expectation) {
        return new ParseException("expected " + expectation, this.getCurrentPositionDescription());
    }

    protected final Token findTokenAtCurrentPosition() {
        for (Token token : this.tokens) {
            String lexeme = this.matchToken(token);
            if (lexeme == null) continue;
            return token;
        }
        return null;
    }

    protected abstract Description getCurrentPositionDescription();

    protected final Lexeme getLastLexeme() {
        return this.lastLexeme;
    }

    @Deprecated
    public abstract String getLastSkips();

    public boolean end() {
        return this.lastLexeme == null;
    }

    public final String match(Token token) throws ParseException {
        this.checkToken(token);
        if (this.lastLexeme == BEGIN_LEXEME) {
            this.advance();
        }
        if (this.lastLexeme == null) {
            return null;
        }
        if (token.isSame(this.lastLexeme.getToken())) {
            return this.lastLexeme.getLex();
        }
        return null;
    }

    public final String matchAdvance(Token token) throws ParseException {
        String lexeme = this.match(token);
        if (lexeme != null) {
            this.advance();
            return lexeme;
        }
        return null;
    }

    protected final boolean matchNextToken() {
        String bestLexeme = null;
        Token bestToken = null;
        for (Token token : this.tokens) {
            String lexeme = this.matchToken(token);
            if (lexeme == null) continue;
            if (bestLexeme == null) {
                bestLexeme = lexeme;
                bestToken = token;
                continue;
            }
            if (bestLexeme.length() >= lexeme.length()) continue;
            this.env.log("Overriding " + bestLexeme + " with " + lexeme);
            bestLexeme = lexeme;
            bestToken = token;
        }
        if (bestLexeme != null) {
            this.lastLexeme = new Lexeme(bestToken, bestLexeme);
            return true;
        }
        return false;
    }

    protected void terminate() {
        this.lastLexeme = null;
    }

    protected abstract String matchToken(Token var1);

    public final ParseException parseFailure(String explanation) {
        return new ParseException(explanation, this.getCurrentPositionDescription());
    }

    public final ParseException parseFailure(Exception reason) {
        return new ParseException(reason, this.getCurrentPositionDescription());
    }

    private String requiredImpl(Token token, String fullExplanation) throws ParseException {
        ParseException exception = this.expected(fullExplanation);
        String lex = this.matchAdvance(token);
        if (lex == null) {
            exception.fillInStackTrace();
            throw exception;
        }
        return lex;
    }

    public final String required(Token token, String explanation) throws ParseException {
        return this.requiredImpl(token, String.valueOf(explanation) + " (" + token + ")");
    }

    public final String required(Token token) throws ParseException {
        return this.requiredImpl(token, token.describe());
    }

    @Deprecated
    public boolean skipUntil(Token token) throws ParseException {
        while (this.lastLexeme != null && !this.lastLexeme.getToken().isSame(token)) {
            this.advance();
        }
        return this.lastLexeme != null && this.lastLexeme.getToken().isSame(token);
    }

    protected static final class Lexeme {
        private final String lex;
        private final Token token;

        public Lexeme(Token token, String lex) {
            this.token = token;
            this.lex = lex;
        }

        final String getLex() {
            return this.lex;
        }

        final Token getToken() {
            return this.token;
        }

        public String toString() {
            return String.valueOf(this.lex) + " [" + this.token.describe() + "]";
        }
    }
}

