/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.type;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.type.ARRAY_TYPE;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.IndexRange;
import com.nestor.interpret.type.TYPE;
import com.nestor.shared.Description;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ARRAY<D extends DATA>
extends DATA<ARRAY<D>> {
    private static final long serialVersionUID = 7330143092081329559L;
    private Object[] data;
    private ARRAY_TYPE<D> declaredType;

    private static String describeRecursive(Object[] root) {
        String res = "[";
        Object[] objectArray = root;
        int n = root.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object.getClass().isArray()) {
                res = String.valueOf(res) + ARRAY.describeRecursive((Object[])object);
            } else {
                if (res != "[") {
                    res = String.valueOf(res) + ",";
                }
                res = String.valueOf(res) + ((Description)object).describe();
            }
            ++n2;
        }
        return String.valueOf(res) + "]";
    }

    private static void eraseRecursive(Object[] root, TYPE elementType) {
        int i = 0;
        while (i < root.length) {
            if (root[i].getClass().isArray()) {
                ARRAY.eraseRecursive((Object[])root[i], elementType);
            } else {
                root[i] = elementType.newInstance();
            }
            ++i;
        }
    }

    public ARRAY(ARRAY_TYPE<D> arrayType) {
        this.declaredType = arrayType;
        this.data = new Object[arrayType.getDimensions().get(0).size()];
        this.createLists(this.data, 0);
    }

    private void createLists(Object[] root, int depth) {
        IndexRange range = this.declaredType.getDimensions().get(depth);
        int i = 0;
        while (i < range.size()) {
            if (depth + 1 < this.declaredType.getDimensions().size()) {
                Object[] nlist;
                root[i] = nlist = new Object[this.declaredType.getDimensions().get(depth + 1).size()];
                this.createLists(nlist, depth + 1);
            } else {
                root[i] = this.declaredType.getElementType().newInstance();
            }
            ++i;
        }
    }

    @Override
    public String describe() {
        return ARRAY.describeRecursive(this.data);
    }

    @Override
    public boolean equalsImpl(ARRAY<D> t) {
        int i = 0;
        while (i < this.data.length) {
            if (!t.data[i].equals(this.data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void erase() {
        ARRAY.eraseRecursive(this.data, this.declaredType.getElementType());
    }

    public D getElement(List<Integer> indexes) throws EvaluationException {
        List<Integer> translated = this.declaredType.getTranslatedIndexes(indexes);
        try {
            Object[] lookup = this.getLastLevelArray(translated);
            return (D)((DATA)lookup[translated.get(translated.size() - 1)]);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvaluationException(e.getMessage());
        }
    }

    private Object[] getLastLevelArray(List<Integer> translated) {
        Object[] lookup = this.data;
        int depth = 0;
        while (depth < translated.size() - 1) {
            lookup = (Object[])lookup[translated.get(depth)];
            ++depth;
        }
        return lookup;
    }

    @Override
    public ARRAY_TYPE<D> getValueType() {
        return this.declaredType;
    }

    public void redim(ARRAY_TYPE<D> newType) {
        if (!newType.getElementType().areEqual(this.declaredType.getElementType())) {
            throw new IllegalArgumentException("Trying to redefine array element type");
        }
        if (newType.getDimensions().size() == this.declaredType.getDimensions().size()) {
            throw new IllegalArgumentException("Trying to redefine array dimension");
        }
        this.declaredType = newType;
        this.data = new Object[newType.getDimensions().get(0).size()];
        this.createLists(this.data, 0);
    }

    public void setElement(List<Integer> indexes, D element) {
        List<Integer> translated = this.declaredType.getTranslatedIndexes(indexes);
        Object[] lookup = this.getLastLevelArray(translated);
        lookup[translated.get((int)(translated.size() - 1)).intValue()] = element;
    }
}

