/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.type;

import com.nestor.interpret.type.ARRAY;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.DATA_TYPE;
import com.nestor.interpret.type.IndexRange;
import com.nestor.interpret.type.TYPE;
import com.nestor.interpret.type.TYPES;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ARRAY_TYPE<D extends DATA>
extends DATA_TYPE<ARRAY<D>> {
    private static final long serialVersionUID = -5198709842965932445L;
    private final List<IndexRange> dimensions;
    private final TYPE<? extends D> elementType;

    public ARRAY_TYPE() {
        this(Collections.EMPTY_LIST, TYPES.DATA_TYPE);
    }

    public ARRAY_TYPE(List<IndexRange> dimensions, TYPE<? extends D> elementType) {
        this.dimensions = new ArrayList<IndexRange>(dimensions);
        this.elementType = elementType;
    }

    @Override
    public boolean areEqual(TYPE other) {
        if (other instanceof ARRAY_TYPE) {
            ARRAY_TYPE arrType = (ARRAY_TYPE)other;
            if (!arrType.elementType.areEqual(this.elementType)) {
                return false;
            }
            return this.dimensions.size() == arrType.dimensions.size();
        }
        return false;
    }

    @Override
    public String describe() {
        return String.valueOf(this.elementType.describe()) + Arrays.toString(this.dimensions.toArray());
    }

    public List<IndexRange> getDimensions() {
        return this.dimensions;
    }

    public final TYPE<? extends D> getElementType() {
        return this.elementType;
    }

    @Override
    public String getName() {
        return this.describe();
    }

    public List<Integer> getTranslatedIndexes(List<Integer> indexes) {
        if (indexes.size() != this.dimensions.size()) {
            throw new IllegalArgumentException("Invalid qualifiers");
        }
        ArrayList<Integer> translated = new ArrayList<Integer>(indexes.size());
        int i = 0;
        while (i < indexes.size()) {
            translated.add(this.dimensions.get(i).translate(indexes.get(i)));
            ++i;
        }
        return translated;
    }

    @Override
    public boolean canPromote(TYPE toType) {
        return false;
    }

    @Override
    public <P extends DATA> P promote(ARRAY<D> value, TYPE<P> toType) {
        return null;
    }

    @Override
    public boolean isAssignableFrom(TYPE other) {
        if (other instanceof ARRAY_TYPE) {
            ARRAY_TYPE arrType = (ARRAY_TYPE)other;
            if (!this.elementType.isAssignableFrom(arrType.elementType)) {
                return false;
            }
            if (this.dimensions.size() == 0) {
                return true;
            }
            return this.dimensions.size() == arrType.dimensions.size();
        }
        return false;
    }

    @Override
    public boolean isInstance(DATA value) {
        return this.isAssignableFrom(value.getValueType());
    }

    @Override
    public boolean isQualifiable() {
        return true;
    }

    @Override
    public ARRAY<D> newInstance() {
        return new ARRAY(this);
    }

    public void redim(List<IndexRange> newDimenstions) {
        if (newDimenstions.size() != this.dimensions.size()) {
            throw new IllegalArgumentException("Uncompatible redim");
        }
        int i = 0;
        while (i < this.dimensions.size()) {
            this.dimensions.set(i, newDimenstions.get(i));
            ++i;
        }
    }
}

