/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.type;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.RuntimeEnv;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.type.ARRAY;
import com.nestor.interpret.type.ARRAY_TYPE;
import com.nestor.interpret.type.ChainQualifier;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.INTEGER;
import com.nestor.interpret.type.Qualifier;
import com.nestor.interpret.type.TYPE;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayQualifier
extends ChainQualifier<ARRAY<DATA>> {
    private static final long serialVersionUID = 1078988802944935701L;
    private final ARRAY_TYPE<? extends DATA> arrayType;
    private final List<Value<INTEGER>> indexes;

    public ArrayQualifier(ARRAY_TYPE<? extends DATA> arrayType, List<Value<INTEGER>> indexes, Qualifier chained) {
        super(chained);
        this.arrayType = arrayType;
        this.indexes = indexes;
    }

    @Override
    public String describe() {
        String res = "[";
        int i = 0;
        while (i < this.indexes.size()) {
            res = String.valueOf(res) + this.indexes.get(i).describe();
            if (i < this.indexes.size() - 1) {
                res = String.valueOf(res) + ",";
            }
            ++i;
        }
        res = String.valueOf(res) + "]";
        return res;
    }

    @Override
    protected DATA getChained(RuntimeEnv env, ARRAY<DATA> unqualified) throws EvaluationException {
        return unqualified.getElement(this.evaluateIndexes(env));
    }

    private List<Integer> evaluateIndexes(RuntimeEnv env) throws EvaluationException {
        ArrayList<Integer> evaluated = new ArrayList<Integer>(this.indexes.size());
        for (Value<INTEGER> index : this.indexes) {
            evaluated.add(index.evaluate(env).intValue());
        }
        return evaluated;
    }

    @Override
    public TYPE<? extends DATA> getQualifiedType() {
        return this.arrayType.getElementType();
    }

    @Override
    protected void setChained(RuntimeEnv env, ARRAY<DATA> unqualified, DATA data) throws EvaluationException {
        unqualified.setElement(this.evaluateIndexes(env), data);
    }
}

