/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.type;

import java.io.Serializable;

public final class IndexRange
implements Serializable {
    private static final long serialVersionUID = -659437743897496387L;
    private final int low;
    private final int high;

    public IndexRange() {
        this.low = 0;
        this.high = -1;
    }

    public IndexRange(int low, int high) {
        if (low > high) {
            throw new IllegalArgumentException("low > high");
        }
        this.low = low;
        this.high = high;
    }

    public int translate(int index) {
        if (index < this.low || index > this.high) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds: " + this);
        }
        return index - this.low;
    }

    public int size() {
        return this.high - this.low + 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IndexRange) {
            return ((IndexRange)obj).low == this.low && ((IndexRange)obj).high == this.high;
        }
        return false;
    }

    public int hashCode() {
        return this.high + this.low << 16;
    }

    public String toString() {
        if (this.low > this.high) {
            return "";
        }
        return String.valueOf(this.low) + " TO " + this.high;
    }
}

