/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.type;

import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.DATA_TYPE;
import com.nestor.interpret.type.STRUCT;
import com.nestor.interpret.type.TYPE;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class STRUCT_TYPE
extends DATA_TYPE<STRUCT> {
    private static final long serialVersionUID = -7385469599041240251L;
    private final String name;
    private final Map<String, TYPE<? extends DATA>> namedContent;

    public STRUCT_TYPE(String name, Map<String, TYPE<? extends DATA>> namedContent) {
        this.name = name;
        this.namedContent = namedContent;
    }

    @Override
    public boolean areEqual(TYPE other) {
        if (other instanceof STRUCT_TYPE) {
            STRUCT_TYPE ost = (STRUCT_TYPE)other;
            if (ost.namedContent.size() != this.namedContent.size()) {
                return false;
            }
            for (Map.Entry<String, TYPE<? extends DATA>> entry : this.namedContent.entrySet()) {
                TYPE<? extends DATA> othType = ost.namedContent.get(entry.getKey());
                if (othType == null) {
                    return false;
                }
                if (othType.areEqual(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String describe() {
        String res = String.valueOf(this.name) + "{";
        for (Map.Entry<String, TYPE<? extends DATA>> entry : this.namedContent.entrySet()) {
            res = String.valueOf(res) + entry.getKey() + " " + StatementTokens.AS.describe();
            res = String.valueOf(res) + " " + entry.getValue().describe() + ";";
        }
        return String.valueOf(res) + "}";
    }

    public String describe(Map<String, DATA> valuesRef) {
        String res = String.valueOf(this.name) + "{";
        for (Map.Entry<String, TYPE<? extends DATA>> entry : this.namedContent.entrySet()) {
            res = String.valueOf(res) + entry.getKey() + " = " + valuesRef.get(entry.getKey()) + ";";
        }
        return String.valueOf(res) + "}";
    }

    public TYPE<? extends DATA> getFieldType(String fieldName) {
        return this.namedContent.get(fieldName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void initializeValue(Map<String, DATA> valuesRef) {
        for (Map.Entry<String, TYPE<? extends DATA>> entry : this.namedContent.entrySet()) {
            valuesRef.put(entry.getKey(), entry.getValue().newInstance());
        }
    }

    @Override
    public boolean canPromote(TYPE toType) {
        return false;
    }

    @Override
    public <P extends DATA> P promote(STRUCT value, TYPE<P> toType) {
        return null;
    }

    @Override
    public boolean isAssignableFrom(TYPE other) {
        return this.areEqual(other);
    }

    @Override
    public boolean isInstance(DATA value) {
        return value.getValueType().areEqual(this);
    }

    @Override
    public boolean isQualifiable() {
        return true;
    }

    @Override
    public STRUCT newInstance() {
        return new STRUCT(this);
    }
}

