/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.type;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.RuntimeEnv;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.PromotionNotSupportedException;
import com.nestor.interpret.type.TYPE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValuePromotor<D extends DATA>
implements Value<D> {
    private static final long serialVersionUID = -4174755339869995805L;
    private final Value original;
    private final TYPE<? extends D> promoteTo;

    public static <D extends DATA> Value<D> createPromotor(Value value, TYPE<D> promoteTo) throws PromotionNotSupportedException {
        if (value.getValueType().areEqual(promoteTo)) {
            return value;
        }
        if (!value.getValueType().canPromote(promoteTo)) {
            throw new PromotionNotSupportedException(value.getValueType(), promoteTo);
        }
        return new ValuePromotor<D>(value, promoteTo);
    }

    private ValuePromotor(Value value, TYPE<? extends D> promoteTo) {
        this.original = value;
        this.promoteTo = promoteTo;
    }

    @Override
    public String describe() {
        return "(" + this.promoteTo.describe() + ")" + this.original.describe();
    }

    @Override
    public D evaluate(RuntimeEnv arg) throws EvaluationException {
        Object orgValue = this.original.evaluate(arg);
        return this.original.getValueType().promote(orgValue, this.promoteTo);
    }

    @Override
    public TYPE<? extends D> getValueType() {
        return this.promoteTo;
    }

    public String toString() {
        return this.describe();
    }
}

