/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.shared.event;

import com.nestor.shared.event.InvocationIterator;
import com.nestor.shared.util.ImmutableList;
import com.nestor.shared.util.PassiveIterator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonoPublisher<T> {
    private T castType = null;
    private Class<T> listenerInterface;
    private ImmutableList<T> rootNode = null;

    public MonoPublisher(Class<T> listenerClass) {
        this.listenerInterface = listenerClass;
        if (!this.listenerInterface.isInterface()) {
            throw new IllegalArgumentException("Provide an interface");
        }
    }

    public synchronized void add(T listener) {
        this.rootNode = new ImmutableList<T>(this.rootNode, listener);
    }

    public synchronized T cast() {
        if (this.castType == null) {
            Class[] classes = new Class[]{this.listenerInterface};
            this.castType = Proxy.newProxyInstance(this.listenerInterface.getClassLoader(), classes, this.createInvocationHandler());
        }
        return this.castType;
    }

    private InvocationHandler createInvocationHandler() {
        return new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                MonoPublisher.this.publish(new InvocationIterator(method, args));
                return null;
            }
        };
    }

    public void publish(PassiveIterator<T> visitor) {
        ImmutableList<T> node = this.rootNode;
        if (node != null) {
            node.traverse(visitor);
        }
    }

    public synchronized void remove(T listener) {
        if (this.rootNode != null) {
            this.rootNode = this.rootNode.remove(listener);
        }
    }

    public synchronized void removeAll() {
        this.rootNode = null;
    }
}

