/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.shared.module;

import com.nestor.shared.module.DependencyCache;
import com.nestor.shared.module.DependencyException;
import com.nestor.shared.module.Module;
import com.nestor.shared.resource.InvocationGuard;
import com.nestor.shared.util.NetNode;
import com.nestor.shared.util.Node;
import com.nestor.shared.util.PassiveIterator;
import com.nestor.shared.util.Traversable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleManager
implements Iterable<Module>,
Traversable<Module> {
    private static Module dummy = new Module(){

        public void shutdown() {
        }

        public void startup(DependencyCache dc) {
        }
    };
    private static Traversable instance = null;
    private Node<Module> dependencies = null;
    Map<Module, ModuleNode> registeredModules = null;

    public static synchronized Traversable getInstance() {
        if (instance == null) {
            instance = new ModuleManager();
        }
        return instance;
    }

    void detectDependencyLoop(final Node<Module> root) throws DependencyException {
        root.traverse(new PassiveIterator<Module>(){
            int count = 0;

            @Override
            public void next(Module node) {
                if (node == root.get()) {
                    ++this.count;
                }
                if (this.count > 1) {
                    throw new DependencyException(node);
                }
            }
        }, Node.TraverseDirection.DEFAULT);
    }

    @Override
    public synchronized Iterator<Module> iterator() {
        HashSet<Module> currentSet = new HashSet<Module>(this.registeredModules.keySet());
        final Iterator<Module> i = currentSet.iterator();
        return new Iterator<Module>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Module next() {
                return (Module)i.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private synchronized Node<Module> rebuildDependencies(Collection<ModuleNode> modules) {
        NetNode<Module> forest = new NetNode<Module>(dummy);
        for (ModuleNode module : modules) {
            if (module.usesCnt != 0) continue;
            forest.append(module);
        }
        return forest;
    }

    synchronized void registerModule(Module m, DependencyCache cache) {
        if (this.registeredModules == null) {
            this.registeredModules = new HashMap<Module, ModuleNode>();
        }
        if (!this.registeredModules.containsKey(m)) {
            this.registeredModules.put(m, new ModuleNode(m));
            m.startup(cache);
        }
    }

    public synchronized void shutdown() {
        if (this.dependencies != null) {
            this.dependencies.traverse(new SetBuilderIterator(){

                public void visitOnce(Module comp) {
                    comp.shutdown();
                }
            }, Node.TraverseDirection.BOTTOM_UP);
            this.dependencies = null;
            this.registeredModules.clear();
        }
    }

    public synchronized void start(Module module) {
        DependencyCache dc = new DependencyCache(module){
            Stack<Module> currentlyRegistering = new Stack();
            {
                this.currentlyRegistering.push(module);
            }

            public void addDependency(Module to) throws DependencyException {
                if (!ModuleManager.this.registeredModules.containsKey(to)) {
                    this.currentlyRegistering.push(to);
                    ModuleManager.this.registerModule(to, this);
                    this.currentlyRegistering.pop();
                } else if (this.currentlyRegistering.peek() != null) {
                    ModuleNode asked = ModuleManager.this.registeredModules.get(this.currentlyRegistering.peek());
                    ModuleNode toNode = ModuleManager.this.registeredModules.get(to);
                    ++asked.usesCnt;
                    toNode.append(asked);
                    ModuleManager.this.detectDependencyLoop(toNode);
                }
            }
        };
        InvocationGuard<5> cacheGuard = new InvocationGuard<5>(dc);
        DependencyCache guardedDC = (DependencyCache)cacheGuard.open();
        this.registerModule(module, guardedDC);
        cacheGuard.close();
        this.dependencies = this.rebuildDependencies(this.registeredModules.values());
    }

    @Override
    public synchronized void traverse(final PassiveIterator<Module> iterator) {
        if (this.dependencies != null) {
            this.dependencies.traverse(new SetBuilderIterator(){

                public void visitOnce(Module comp) {
                    iterator.next(comp);
                }
            }, Node.TraverseDirection.TOP_DOWN);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModuleNode
    extends NetNode<Module> {
        int usesCnt;

        ModuleNode(Module sc) {
            super(sc);
            this.usesCnt = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SetBuilderIterator
    implements PassiveIterator<Module> {
        private Set<Module> visited = new HashSet<Module>();

        SetBuilderIterator() {
        }

        @Override
        public void next(Module n) {
            if (!this.visited.contains(n)) {
                this.visitOnce(n);
                this.visited.add(n);
            }
        }

        public abstract void visitOnce(Module var1);
    }
}

