/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.shared.resource;

import com.nestor.shared.resource.Guard;
import com.nestor.shared.resource.ObjectUnavailableException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationGuard<T>
implements Guard<T>,
InvocationHandler {
    private boolean scopeClosed = false;
    private T guardProxy = null;
    private Object guardedObject;

    public InvocationGuard(T guarded) {
        this.guardedObject = guarded;
    }

    @Override
    public synchronized T open() {
        if (this.guardProxy == null) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?>[] interfaces = this.guardedObject.getClass().getInterfaces();
            this.guardProxy = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)this);
        }
        return this.guardProxy;
    }

    @Override
    public synchronized void close() {
        this.scopeClosed = true;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!this.scopeClosed) {
            return method.invoke(this.guardedObject, args);
        }
        throw new ObjectUnavailableException(this.guardedObject);
    }
}

