/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.shared.util;

import com.nestor.shared.util.PassiveIterator;
import com.nestor.shared.util.Traversable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableList<T>
implements Traversable<T> {
    private ImmutableList<T> next = null;
    private T content = null;

    public ImmutableList(ImmutableList<T> disp, T listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.content = listener;
        this.next = disp;
    }

    public ImmutableList<T> remove(T listener) {
        ImmutableList<T> current = this;
        ImmutableList<T> found = null;
        while (current != null) {
            if (current.content != listener) continue;
            found = current;
            break;
        }
        if (found == null) {
            return this;
        }
        current = this;
        ImmutableList<T> copy = null;
        while (current != found) {
            copy = new ImmutableList<T>(copy, current.content);
            current = current.next;
        }
        if (copy != null) {
            while (copy.next != null) {
                copy = copy.next;
            }
            copy.next = current.next;
        } else {
            copy = current.next;
        }
        return copy;
    }

    @Override
    public void traverse(PassiveIterator<T> visitor) {
        visitor.next(this.content);
        if (this.next != null) {
            this.next.traverse(visitor);
        }
    }
}

