/*
 * Decompiled with CFR 0.152.
 */
package org.spring4gwt.server;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringGwtRemoteServiceServlet
extends RemoteServiceServlet {
    private static final Logger LOG = Logger.getLogger(SpringGwtRemoteServiceServlet.class);

    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Spring GWT service exporter deployed");
        }
    }

    public String processCall(String payload) throws SerializationException {
        try {
            Object handler = this.getBean(this.getThreadLocalRequest());
            RPCRequest rpcRequest = RPC.decodeRequest((String)payload, handler.getClass(), (SerializationPolicyProvider)this);
            this.onAfterRequestDeserialized(rpcRequest);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Invoking " + handler.getClass().getName() + "." + rpcRequest.getMethod().getName()));
            }
            return RPC.invokeAndEncodeResponse((Object)handler, (Method)rpcRequest.getMethod(), (Object[])rpcRequest.getParameters(), (SerializationPolicy)rpcRequest.getSerializationPolicy());
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.log("An IncompatibleRemoteServiceException was thrown while processing this call.", ex);
            return RPC.encodeResponseForFailure(null, (Throwable)ex);
        }
    }

    protected Object getBean(HttpServletRequest request) {
        String service = this.getService(request);
        Object bean = this.getBean(service);
        if (!(bean instanceof RemoteService)) {
            throw new IllegalArgumentException("Spring bean is not a GWT RemoteService: " + service + " (" + bean + ")");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Bean for service " + service + " is " + bean));
        }
        return bean;
    }

    protected String getService(HttpServletRequest request) {
        String url = request.getRequestURI();
        String service = url.substring(url.lastIndexOf("/") + 1);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Service for URL " + url + " is " + service));
        }
        return service;
    }

    protected Object getBean(String name) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (applicationContext == null) {
            throw new IllegalStateException("No Spring web application context found");
        }
        if (!applicationContext.containsBean(name)) {
            throw new IllegalArgumentException("Spring bean not found: " + name);
        }
        return applicationContext.getBean(name);
    }
}

