/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.expression;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.Operator;
import com.nestor.interpret.expression.RuntimeEnv;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.TYPE;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Expression<VAL extends DATA>
implements Value<VAL> {
    private static final long serialVersionUID = -4949326201753148632L;
    private final Operator<VAL, VAL> operation;
    private TYPE<? extends VAL> resultType = null;
    private final Collection<? extends Value<? extends VAL>> values;

    public Expression(Operator<VAL, VAL> operation, Collection<? extends Value<? extends VAL>> values) {
        this.operation = operation;
        this.values = values;
    }

    @Override
    public String describe() {
        String res = null;
        for (Value<VAL> value : this.values) {
            res = res == null ? value.describe() : String.valueOf(res) + this.operation.describe() + value.describe();
        }
        return res;
    }

    @Override
    public VAL evaluate(RuntimeEnv env) throws EvaluationException {
        Object result = null;
        boolean first = true;
        for (Value<VAL> value : this.values) {
            if (first) {
                result = value.evaluate(env);
                first = false;
                continue;
            }
            result = this.operation.operation(result, value.evaluate(env));
        }
        return (VAL)result;
    }

    @Override
    public TYPE<? extends VAL> getValueType() {
        if (this.resultType != null) {
            return this.resultType;
        }
        ArrayList types = new ArrayList(this.values.size());
        for (Value<VAL> v : this.values) {
            types.add(v.getValueType());
        }
        this.resultType = this.operation.resultType(types);
        return this.resultType;
    }
}

