/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.expression.relational;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.RuntimeEnv;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.expression.relational.RelationalOperator;
import com.nestor.interpret.type.BOOLEAN;
import com.nestor.interpret.type.NUMBER;
import com.nestor.interpret.type.TYPE;
import com.nestor.interpret.type.TYPES;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RelationalExpression
implements Value<BOOLEAN> {
    private static final long serialVersionUID = -710002202223143119L;
    private final RelationalExpression leftEquation;
    private final Value<? extends NUMBER> leftNumber;
    private final Value<? extends NUMBER> next;
    private final RelationalOperator operator;

    public RelationalExpression(RelationalOperator operator, RelationalExpression equation, Value<? extends NUMBER> next) {
        this.operator = operator;
        this.leftEquation = equation;
        this.leftNumber = null;
        this.next = next;
    }

    public RelationalExpression(RelationalOperator operator, Value<? extends NUMBER> first, Value<? extends NUMBER> next) {
        this.operator = operator;
        this.leftNumber = first;
        this.leftEquation = null;
        this.next = next;
    }

    @Override
    public String describe() {
        if (this.leftEquation != null) {
            return String.valueOf(this.leftEquation.describe()) + this.operator.describe() + this.next.describe();
        }
        return String.valueOf(this.leftNumber.describe()) + this.operator.describe() + this.next.describe();
    }

    @Override
    public BOOLEAN evaluate(RuntimeEnv env) throws EvaluationException {
        if (this.leftNumber != null) {
            return (BOOLEAN)this.operator.operation(this.leftNumber.evaluate(env), this.next.evaluate(env));
        }
        if (this.leftEquation.evaluate(env).booleanValue()) {
            return (BOOLEAN)this.operator.operation(this.leftEquation.getRightMostValue().evaluate(env), this.next.evaluate(env));
        }
        return new BOOLEAN(false);
    }

    private Value<? extends NUMBER> getRightMostValue() {
        return this.next;
    }

    @Override
    public TYPE<? extends BOOLEAN> getValueType() {
        return TYPES.BOOLEAN_TYPE;
    }
}

