/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic;

import com.nestor.interpret.jbasic.JBasicCompiler;
import com.nestor.interpret.jbasic.JBasicProgram;
import com.nestor.interpret.jbasic.JBasicScannerFactory;
import com.nestor.interpret.jbasic.parse.InterpretException;
import com.nestor.interpret.jbasic.profile.qbasic.QBasicConfigurator;
import com.nestor.interpret.jbasic.profile.qbasic.services.simple.SimpleRuntimeServiceProvider;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.parse.SimpleParseEnv;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;

public class JBasicStarter {
    private boolean compile = false;
    private boolean run = false;
    private String runFile = null;
    private String sourceFile = null;

    public static void main(String[] args) {
        new JBasicStarter(args);
    }

    private static void printUsage() {
        System.out.println("Usage {-compile | -run} <file-name>");
    }

    public JBasicStarter(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (IllegalArgumentException e1) {
            JBasicStarter.printUsage();
            System.exit(1);
        }
        if (this.compile) {
            QBasicConfigurator qbasicConfigurator = new QBasicConfigurator();
            SimpleParseEnv env = new SimpleParseEnv();
            try {
                JBasicScannerFactory scannerFactory = new JBasicScannerFactory(qbasicConfigurator, env);
                Scanner scanner = scannerFactory.createQBasicScanner(new FileReader(this.sourceFile));
                ByteArrayOutputStream compilierOutput = new ByteArrayOutputStream();
                JBasicCompiler interpreter = new JBasicCompiler(qbasicConfigurator);
                interpreter.compile(this.sourceFile, scanner, env, compilierOutput);
                compilierOutput.close();
                FileOutputStream fileOutput = new FileOutputStream(this.runFile);
                fileOutput.write(compilierOutput.toByteArray());
                fileOutput.close();
            }
            catch (IOException e) {
                this.printError(e);
            }
            catch (ParseException e) {
                this.printError(e);
            }
            catch (InterpretException e) {
                this.printError(e);
            }
        }
        if (this.run) {
            try {
                ObjectInputStream oos = new ObjectInputStream(new FileInputStream(this.runFile));
                JBasicProgram program = (JBasicProgram)oos.readObject();
                oos.close();
                program.run(new SimpleRuntimeServiceProvider());
            }
            catch (FileNotFoundException e) {
                this.printError(e);
            }
            catch (IOException e) {
                this.printError(e);
            }
            catch (ClassNotFoundException e) {
                this.printError(e);
            }
            catch (RuntimeException e) {
                this.printException(e);
            }
        }
    }

    private void parseOptions(String[] args) throws IllegalArgumentException {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("-compile")) {
                this.compile = true;
            } else if (arg.endsWith("-run")) {
                this.run = true;
            } else {
                if (i != args.length - 1) {
                    throw new IllegalArgumentException("File name should be last element");
                }
                if (this.compile) {
                    this.sourceFile = arg;
                    if (this.run) {
                        int idx = arg.lastIndexOf(46);
                        this.runFile = idx < 0 ? String.valueOf(arg) + ".ser" : String.valueOf(arg.substring(0, idx)) + ".ser";
                    }
                } else if (this.run) {
                    this.runFile = arg;
                }
            }
            ++i;
        }
        if (!this.compile && !this.run) {
            throw new IllegalArgumentException("Specify either 'compile' or 'run'");
        }
        if (this.sourceFile == null && this.runFile == null) {
            throw new IllegalArgumentException("Specify file name");
        }
    }

    private void printException(Throwable e) {
        System.out.println("Exception occured: " + e.getMessage());
        e.printStackTrace();
    }

    private void printError(Throwable e) {
        System.out.println("\n=====================================================\n");
        e.printStackTrace();
        System.exit(2);
    }
}

