/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.lang;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.RuntimeEnv;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.jbasic.lang.Function;
import com.nestor.interpret.jbasic.lang.Parameter;
import com.nestor.interpret.jbasic.lang.RuntimeContext;
import com.nestor.interpret.jbasic.lang.RuntimeStack;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.lang.Variable;
import com.nestor.interpret.jbasic.statement.ReturnCode;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.TYPE;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCall
extends Statement
implements Value<DATA> {
    private static final long serialVersionUID = 3623714531135282148L;
    private final List<Value<? extends DATA>> arguments;
    private final Function function;

    public FunctionCall(Function function, List<Value<? extends DATA>> arguments) {
        this.function = function;
        this.arguments = arguments;
    }

    @Override
    public String describe() {
        return this.function.describe();
    }

    @Override
    public DATA evaluate(RuntimeEnv env) throws EvaluationException {
        RuntimeContext context = (RuntimeContext)env;
        List<Parameter> parameters = this.function.getParameters();
        LinkedList<DATA> argumentValues = new LinkedList<DATA>();
        for (Value<? extends DATA> argument : this.arguments) {
            argumentValues.add(argument.evaluate(context));
        }
        RuntimeStack runtimeStack = context.stack();
        runtimeStack.getClass();
        new Stack.Frame(runtimeStack, this.function.getName(), Stack.BlockKind.CODE);
        context.stack().addVariable(new Variable(this.function.getName(), this.function.getReturnType()));
        Iterator<Parameter> parameterIterator = parameters.iterator();
        Iterator argumentValueIterator = argumentValues.iterator();
        while (parameterIterator.hasNext()) {
            Parameter parameter = parameterIterator.next();
            DATA argumentValue = (DATA)argumentValueIterator.next();
            String parameterName = parameter.getName();
            TYPE<? extends DATA> parameterType = parameter.getType();
            Variable variable = new Variable(parameterName, parameterType);
            context.stack().addVariable(variable);
            context.stack().getVariable(variable.getName()).setValue(argumentValue);
        }
        this.function.execute(context);
        Variable variable = context.stack().getVariable(this.function.getName());
        context.stack().popFrame();
        return variable.evaluate(context);
    }

    @Override
    protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
        this.evaluate(context);
        return ReturnCode.SUCCESS;
    }

    @Override
    public TYPE<? extends DATA> getValueType() {
        return this.function.getReturnType();
    }
}

