/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.lang;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.jbasic.lang.Parameter;
import com.nestor.interpret.jbasic.lang.RuntimeContext;
import com.nestor.interpret.jbasic.lang.RuntimeStack;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.lang.Sub;
import com.nestor.interpret.jbasic.lang.Variable;
import com.nestor.interpret.jbasic.statement.ReturnCode;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.TYPE;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubCall
extends Statement {
    private static final long serialVersionUID = 2484776462951233631L;
    private final List<Value<? extends DATA>> arguments;
    private final Sub sub;

    public SubCall(Sub function, List<Value<? extends DATA>> arguments) {
        this.sub = function;
        this.arguments = arguments;
    }

    @Override
    public String describe() {
        return this.sub.describe();
    }

    @Override
    protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
        List<Parameter> parameters = this.sub.getParameters();
        LinkedList<DATA> argumentValues = new LinkedList<DATA>();
        for (Value<? extends DATA> argument : this.arguments) {
            argumentValues.add(argument.evaluate(context));
        }
        RuntimeStack runtimeStack = context.stack();
        runtimeStack.getClass();
        new Stack.Frame(runtimeStack, this.sub.getName(), Stack.BlockKind.CODE);
        Iterator<Parameter> parameterIterator = parameters.iterator();
        Iterator argumentValueIterator = argumentValues.iterator();
        while (parameterIterator.hasNext()) {
            Parameter parameter = parameterIterator.next();
            DATA argumentValue = (DATA)argumentValueIterator.next();
            String parameterName = parameter.getName();
            TYPE<? extends DATA> parameterType = parameter.getType();
            Variable variable = new Variable(parameterName, parameterType);
            context.stack().addVariable(variable);
            context.stack().getVariable(variable.getName()).setValue(argumentValue);
        }
        ReturnCode code = this.sub.execute(context);
        context.stack().popFrame();
        return code;
    }
}

