/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.lang;

import com.nestor.interpret.jbasic.lang.DeclarationException;
import com.nestor.interpret.jbasic.lang.Function;
import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.RedeclarationException;
import com.nestor.interpret.jbasic.lang.RuntimeContext;
import com.nestor.interpret.jbasic.lang.UndeclaredIdentifierException;
import com.nestor.interpret.jbasic.lang.Variable;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.TYPE;
import com.nestor.shared.Description;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VariableLookup
implements Description,
Serializable {
    private static final long serialVersionUID = 1532031714278720392L;
    private final LookupKind lookupKind;
    protected final String name;
    private TYPE<? extends DATA> type;

    public static VariableLookup createFnReturnVarLookup(ParseContext context, Function function) {
        TYPE<? extends DATA> type = function.getReturnType();
        String name = function.getName();
        return VariableLookup.createLocalLookupImpl(name, type);
    }

    public static VariableLookup createGlobalLookup(ParseContext context, String name) throws UndeclaredIdentifierException {
        TYPE<? extends DATA> type = context.moduleBuilder().getVariable(name).getValueType();
        return new VariableLookup(name, (TYPE)type, LookupKind.GLOBAL){
            private static final long serialVersionUID = -982300510667537851L;

            public Variable lookup(RuntimeContext ctx) {
                return ctx.module().getVariable(this.name);
            }
        };
    }

    public static VariableLookup createImplicitLookup(ParseContext context, String name, final TYPE<? extends DATA> type) throws RedeclarationException {
        context.stack().addVariable(new Variable(name, type));
        return new VariableLookup(name, type, LookupKind.IMPLICIT){
            private static final long serialVersionUID = -1755468449199148447L;

            public Variable lookup(RuntimeContext ctx1) {
                if (ctx1.stack().getVariable(this.name) == null) {
                    Variable var = new Variable(this.name, type);
                    ctx1.stack().addVariable(var);
                    return var;
                }
                return ctx1.stack().getVariable(this.name);
            }
        };
    }

    public static VariableLookup createLocalLookup(ParseContext context, String name) throws UndeclaredIdentifierException {
        TYPE<? extends DATA> type = context.stack().getVariable(name).getValueType();
        return VariableLookup.createLocalLookupImpl(name, type);
    }

    private static VariableLookup createLocalLookupImpl(String name, TYPE<? extends DATA> type) {
        return new VariableLookup(name, (TYPE)type, LookupKind.LOCAL){
            private static final long serialVersionUID = 9090607447568637311L;

            public Variable lookup(RuntimeContext ctx) {
                return ctx.stack().getVariable(this.name);
            }
        };
    }

    public static VariableLookup createLookup(ParseContext context, String identifier, TYPE<? extends DATA> defaultType) throws DeclarationException {
        if (context.stack().containsVariable(identifier)) {
            defaultType = context.stack().getVariable(identifier).getValueType();
            return VariableLookup.createLocalLookup(context, identifier);
        }
        if (context.moduleBuilder().containsVariable(identifier)) {
            defaultType = context.moduleBuilder().getVariable(identifier).getValueType();
            return VariableLookup.createGlobalLookup(context, identifier);
        }
        if (context.identify(identifier) != null) {
            throw new RedeclarationException(identifier, context.identify(identifier));
        }
        return VariableLookup.createImplicitLookup(context, identifier, defaultType);
    }

    VariableLookup(String name, TYPE<? extends DATA> type, LookupKind lookupKind) {
        this.name = name;
        this.type = type;
        this.lookupKind = lookupKind;
    }

    @Override
    public String describe() {
        return (Object)((Object)this.lookupKind) + " " + this.name;
    }

    public LookupKind getLookupKind() {
        return this.lookupKind;
    }

    public final String getName() {
        return this.name;
    }

    public TYPE<? extends DATA> getValueType() {
        return this.type;
    }

    public abstract Variable lookup(RuntimeContext var1);

    public String toString() {
        return this.describe();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LookupKind {
        GLOBAL,
        IMPLICIT,
        LOCAL;

    }
}

