/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.libs;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.jbasic.lang.DeclarationException;
import com.nestor.interpret.jbasic.lang.Function;
import com.nestor.interpret.jbasic.lang.ModuleBuilder;
import com.nestor.interpret.jbasic.lang.Parameter;
import com.nestor.interpret.jbasic.lang.RedeclarationException;
import com.nestor.interpret.jbasic.lang.RuntimeContext;
import com.nestor.interpret.jbasic.libs.AbstractFunction;
import com.nestor.interpret.jbasic.libs.AbstractLibrary;
import com.nestor.interpret.jbasic.statement.ReturnCode;
import com.nestor.interpret.type.DOUBLE;
import com.nestor.interpret.type.TYPES;
import java.io.Serializable;

public final class Maths
extends AbstractLibrary {
    private static Function createMathFunction(final FunctionComputer mfn) {
        final Parameter arg = new Parameter("x", TYPES.DOUBLE_TYPE);
        Function fn = new Function(mfn.name, TYPES.DOUBLE_TYPE, arg);
        fn.implement(new AbstractFunction(fn){
            private static final long serialVersionUID = -8504940597271333707L;

            protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
                DOUBLE X = (DOUBLE)context.stack().getVariable(arg.getName()).evaluate(context);
                double x = X.doubleValue();
                double computed = mfn.compute(x);
                context.stack().getVariable(mfn.name).setValue(new DOUBLE(computed));
                return ReturnCode.SUCCESS;
            }
        });
        return fn;
    }

    private static void loadImpl(ModuleBuilder program) throws RedeclarationException {
        program.addFunction(Maths.createMathFunction(new FunctionComputer("ASIN"){
            private static final long serialVersionUID = 7493806180025521957L;

            public double compute(double x) {
                return Math.asin(x);
            }
        }));
        program.addFunction(Maths.createMathFunction(new FunctionComputer("SIN"){
            private static final long serialVersionUID = 7360701363791056757L;

            public double compute(double x) {
                return Math.sin(x);
            }
        }));
        program.addFunction(Maths.createMathFunction(new FunctionComputer("SINH"){
            private static final long serialVersionUID = -6910739665737927723L;

            public double compute(double x) {
                return Math.sinh(x);
            }
        }));
        program.addFunction(Maths.createMathFunction(new FunctionComputer("ACOS"){
            private static final long serialVersionUID = 4569536840565336930L;

            public double compute(double x) {
                return Math.acos(x);
            }
        }));
        program.addFunction(Maths.createMathFunction(new FunctionComputer("COS"){
            private static final long serialVersionUID = 7366765717927342731L;

            public double compute(double x) {
                return Math.cos(x);
            }
        }));
        program.addFunction(Maths.createMathFunction(new FunctionComputer("COSH"){
            private static final long serialVersionUID = -6358503642248026722L;

            public double compute(double x) {
                return Math.cosh(x);
            }
        }));
        program.addFunction(Maths.createMathFunction(new FunctionComputer("ATAN"){
            private static final long serialVersionUID = -6163533437531302302L;

            public double compute(double x) {
                return Math.atan(x);
            }
        }));
        program.addFunction(Maths.createMathFunction(new FunctionComputer("TAN"){
            private static final long serialVersionUID = -5473426421708567626L;

            public double compute(double x) {
                return Math.tan(x);
            }
        }));
        program.addFunction(Maths.createMathFunction(new FunctionComputer("TANH"){
            private static final long serialVersionUID = 925980524477539065L;

            public double compute(double x) {
                return Math.tanh(x);
            }
        }));
        program.addFunction(Maths.createMathFunction(new FunctionComputer("LN"){
            private static final long serialVersionUID = -2010253135554394904L;

            public double compute(double x) {
                return Math.log(x);
            }
        }));
        program.addFunction(Maths.createMathFunction(new FunctionComputer("ABS"){
            private static final long serialVersionUID = -6142008498040942403L;

            public double compute(double x) {
                return Math.abs(x);
            }
        }));
        program.addFunction(Maths.createMathFunction(new FunctionComputer("EXP"){
            private static final long serialVersionUID = 8593368617112451059L;

            public double compute(double x) {
                return Math.exp(x);
            }
        }));
        program.addFunction(Maths.createMathFunction(new FunctionComputer("SQRT"){
            private static final long serialVersionUID = 7133075133587519122L;

            public double compute(double x) {
                return Math.sqrt(x);
            }
        }));
        program.addFunction(Maths.createMathFunction(new FunctionComputer("SGN"){
            private static final long serialVersionUID = 5785953006537442058L;

            public double compute(double x) {
                return Math.signum(x);
            }
        }));
    }

    public void load(ModuleBuilder program) throws DeclarationException {
        this.addConstant(program, "PI", new DOUBLE(Math.PI));
        this.addConstant(program, "E", new DOUBLE(Math.E));
        Maths.loadImpl(program);
    }

    private static abstract class FunctionComputer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String name;

        public FunctionComputer(String name) {
            this.name = name;
        }

        public abstract double compute(double var1);
    }
}

