/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.libs;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.jbasic.lang.DeclarationException;
import com.nestor.interpret.jbasic.lang.Function;
import com.nestor.interpret.jbasic.lang.ModuleBuilder;
import com.nestor.interpret.jbasic.lang.Parameter;
import com.nestor.interpret.jbasic.lang.RedeclarationException;
import com.nestor.interpret.jbasic.lang.RuntimeContext;
import com.nestor.interpret.jbasic.lang.Sub;
import com.nestor.interpret.jbasic.libs.AbstractFunction;
import com.nestor.interpret.jbasic.libs.AbstractLibrary;
import com.nestor.interpret.jbasic.libs.AbstractSub;
import com.nestor.interpret.jbasic.statement.ReturnCode;
import com.nestor.interpret.type.DOUBLE;
import com.nestor.interpret.type.INTEGER;
import com.nestor.interpret.type.TYPES;
import java.util.Random;

public class Std
extends AbstractLibrary {
    private Random random = new Random();

    public void load(ModuleBuilder program) throws DeclarationException {
        Std.loadStatic(program, this);
    }

    private static void loadStatic(ModuleBuilder program, Std std) throws RedeclarationException {
        final Function fn = new Function("RND", TYPES.DOUBLE_TYPE, new Parameter[0]);
        final Random random = std.random;
        fn.implement(new AbstractFunction(fn){
            private static final long serialVersionUID = 1091470126508741001L;

            protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
                double rnd = random.nextDouble();
                context.stack().getVariable(fn.getName()).setValue(new DOUBLE(rnd));
                return ReturnCode.SUCCESS;
            }
        });
        program.addFunction(fn);
        final Parameter arg = new Parameter("seed", TYPES.INTEGER_TYPE);
        Sub sub = new Sub("RANDOMIZE", arg);
        final Random random2 = std.random;
        sub.implement(new AbstractSub(sub){
            private static final long serialVersionUID = 0L;

            protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
                INTEGER s = (INTEGER)context.stack().getVariable(arg.getName()).evaluate(context);
                random2.setSeed(s.intValue());
                return ReturnCode.SUCCESS;
            }
        });
        program.addSub(sub);
        fn = new Function("TIMER", TYPES.INTEGER_TYPE, new Parameter[0]);
        fn.implement(new AbstractFunction(fn){
            private static final long serialVersionUID = 1091470126508741001L;

            protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
                INTEGER time = new INTEGER((int)System.currentTimeMillis());
                context.stack().getVariable(fn.getName()).setValue(time);
                return ReturnCode.SUCCESS;
            }
        });
        program.addFunction(fn);
    }
}

