/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.jbasic.lang.Function;
import com.nestor.interpret.jbasic.lang.Parameter;
import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.RedeclarationException;
import com.nestor.interpret.jbasic.lang.Sub;
import com.nestor.interpret.jbasic.parse.InterpretException;
import com.nestor.interpret.jbasic.parse.StatementParser;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.parse.SyntaxTokens;
import com.nestor.interpret.jbasic.parse.VLOnlyUndeclared;
import com.nestor.interpret.jbasic.parse.VariableList;
import com.nestor.interpret.jbasic.parse.VariableListParser;
import com.nestor.interpret.jbasic.statement.NOP;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.token.StandardTokens;
import com.nestor.interpret.token.Token;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.TYPE;
import com.nestor.shared.Description;
import java.util.ArrayList;
import java.util.LinkedHashMap;

final class CallableDefParser
extends StatementParser {
    CallableDefParser() {
        super(true);
    }

    protected Statement parseStatement(Scanner scanner, ParseContext context) throws ParseException, InterpretException {
        Token callableType;
        if (scanner.matchAdvance(StatementTokens.DECLARE) == null) {
            return null;
        }
        if (scanner.matchAdvance(StatementTokens.FUNCTION) != null) {
            callableType = StatementTokens.FUNCTION;
        } else if (scanner.matchAdvance(StatementTokens.SUB) != null) {
            callableType = StatementTokens.SUB;
        } else {
            throw scanner.expected(StatementTokens.FUNCTION);
        }
        String identifier = scanner.required(SyntaxTokens.IDENTIFIER);
        Description identified = context.identify(identifier);
        if (identified != null) {
            scanner.parseFailure(new RedeclarationException(identifier, identified));
        }
        TYPE<? extends DATA> retType = callableType == StatementTokens.FUNCTION ? context.parseHelper().requireTypeDeclaration(scanner) : null;
        LinkedHashMap<String, TYPE<? extends DATA>> args = new LinkedHashMap<String, TYPE<? extends DATA>>();
        if (scanner.matchAdvance(StandardTokens.LP) != null) {
            VLOnlyUndeclared filter = new VLOnlyUndeclared();
            VariableListParser varParser = new VariableListParser(context, filter);
            VariableList list = varParser.parse(scanner, context);
            args.putAll(list.getVariables());
            scanner.required(StandardTokens.RP);
        }
        ArrayList<Parameter> argList = new ArrayList<Parameter>(args.size());
        for (String varName : args.keySet()) {
            argList.add(new Parameter(varName, (TYPE)args.get(varName)));
        }
        if (callableType == StatementTokens.FUNCTION) {
            context.moduleBuilder().addFunction(new Function(identifier, retType, argList));
        } else {
            context.moduleBuilder().addSub(new Sub(identifier, argList));
        }
        return NOP.INSTANCE;
    }
}

