/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.jbasic.lang.Callable;
import com.nestor.interpret.jbasic.lang.DeclarationException;
import com.nestor.interpret.jbasic.lang.Function;
import com.nestor.interpret.jbasic.lang.Parameter;
import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.RedeclarationException;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.lang.Sub;
import com.nestor.interpret.jbasic.lang.Variable;
import com.nestor.interpret.jbasic.parse.StatementParser;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.parse.SyntaxTokens;
import com.nestor.interpret.jbasic.parse.VLOnlyUndeclared;
import com.nestor.interpret.jbasic.parse.VariableList;
import com.nestor.interpret.jbasic.parse.VariableListParser;
import com.nestor.interpret.jbasic.statement.FunctionEndStatement;
import com.nestor.interpret.jbasic.statement.NOP;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.jbasic.statement.SubEndStatement;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.token.StandardTokens;
import com.nestor.interpret.token.Token;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.TYPE;
import com.nestor.shared.Description;
import java.util.ArrayList;
import java.util.LinkedHashMap;

final class CallableParser
extends StatementParser {
    CallableParser() {
        super(false);
    }

    protected Statement parseStatement(Scanner scanner, ParseContext context) throws ParseException, DeclarationException {
        Token callableTokenMatched;
        if (scanner.matchAdvance(StatementTokens.FUNCTION) != null) {
            callableTokenMatched = StatementTokens.FUNCTION;
        } else if (scanner.matchAdvance(StatementTokens.SUB) != null) {
            callableTokenMatched = StatementTokens.SUB;
        } else {
            return null;
        }
        String identifier = scanner.required(SyntaxTokens.IDENTIFIER);
        Description identified = context.identify(identifier);
        if (identified != null) {
            boolean preDeclared = false;
            if (callableTokenMatched == StatementTokens.FUNCTION) {
                if (context.moduleBuilder().containsFunction(identifier)) {
                    preDeclared = true;
                }
            } else if (context.moduleBuilder().containsSub(identifier)) {
                preDeclared = true;
            }
            if (!preDeclared) {
                throw new RedeclarationException(identifier, identified);
            }
        }
        TYPE<? extends DATA> retType = callableTokenMatched == StatementTokens.FUNCTION ? context.parseHelper().requireTypeDeclaration(scanner) : null;
        LinkedHashMap<String, TYPE<? extends DATA>> args = new LinkedHashMap<String, TYPE<? extends DATA>>();
        if (scanner.matchAdvance(StandardTokens.LP) != null) {
            VLOnlyUndeclared filter = new VLOnlyUndeclared();
            VariableListParser varParser = new VariableListParser(context, filter);
            VariableList list = varParser.parse(scanner, context);
            args.putAll(list.getVariables());
            scanner.required(StandardTokens.RP);
        }
        ArrayList<Parameter> argList = new ArrayList<Parameter>(args.size());
        for (String varName : args.keySet()) {
            argList.add(new Parameter(varName, (TYPE)args.get(varName)));
        }
        Callable decl = callableTokenMatched == StatementTokens.FUNCTION ? new Function(identifier, retType, argList) : new Sub(identifier, argList);
        Callable callable = decl.resolveDefinition(context);
        super.requireEOL(scanner);
        if (callableTokenMatched == StatementTokens.FUNCTION) {
            Stack stack = context.stack();
            stack.getClass();
            stack.new Stack.Frame(identifier, Stack.BlockKind.FUNCTION);
        } else {
            Stack stack = context.stack();
            stack.getClass();
            stack.new Stack.Frame(identifier, Stack.BlockKind.SUB);
        }
        for (String varName : args.keySet()) {
            context.stack().addVariable(new Variable(varName, (TYPE)args.get(varName)));
        }
        Statement body = callableTokenMatched == StatementTokens.FUNCTION ? context.parseHelper().requireStatementBlock(scanner, FunctionEndStatement.class) : context.parseHelper().requireStatementBlock(scanner, SubEndStatement.class);
        callable.implement(body);
        context.stack().popFrame();
        return NOP.INSTANCE;
    }
}

