/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.RedeclarationException;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.lang.Variable;
import com.nestor.interpret.jbasic.parse.BlockBuilder;
import com.nestor.interpret.jbasic.parse.StatementParser;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.parse.VLAtLeastOne;
import com.nestor.interpret.jbasic.parse.VLOnlyUndeclared;
import com.nestor.interpret.jbasic.parse.VariableList;
import com.nestor.interpret.jbasic.parse.VariableListParser;
import com.nestor.interpret.jbasic.statement.LocalDimStatement;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.TYPE;
import java.util.Map;

final class DimParser
extends StatementParser {
    DimParser() {
        super(true);
    }

    protected Statement parseStatement(Scanner scanner, ParseContext context) throws ParseException, RedeclarationException {
        if (scanner.matchAdvance(StatementTokens.DIM) == null) {
            return null;
        }
        boolean global = context.stack().getCurrentBlock().getType() == Stack.BlockKind.TOPLEVEL;
        VLOnlyUndeclared filter = new VLOnlyUndeclared(new VLAtLeastOne());
        VariableListParser varParser = new VariableListParser(context, filter);
        VariableList list = varParser.parse(scanner, context);
        BlockBuilder block = new BlockBuilder(false);
        for (Map.Entry<String, TYPE<? extends DATA>> pair : list.getVariables().entrySet()) {
            if (global) {
                context.moduleBuilder().addVariable(new Variable(pair.getKey(), pair.getValue()));
                continue;
            }
            context.stack().addVariable(new Variable(pair.getKey(), pair.getValue()));
            LocalDimStatement dimAsStatement = new LocalDimStatement(pair.getKey(), pair.getValue());
            block.addStatement(dimAsStatement);
        }
        return block.getStatementNonNull();
    }
}

