/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.parse.InterpretException;
import com.nestor.interpret.jbasic.parse.StatementParser;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.statement.ExitStatement;
import com.nestor.interpret.jbasic.statement.FunctionEndStatement;
import com.nestor.interpret.jbasic.statement.IfEndStatement;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.jbasic.statement.SubEndStatement;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;

final class EndParser
extends StatementParser {
    EndParser() {
        super(true);
    }

    protected Statement parseStatement(Scanner scanner, ParseContext context) throws ParseException, InterpretException {
        if (scanner.matchAdvance(StatementTokens.END) == null) {
            return null;
        }
        if (scanner.matchAdvance(StatementTokens.FUNCTION) != null) {
            if (context.stack().getCurrentBlock().getType() != Stack.BlockKind.FUNCTION) {
                throw scanner.expected(StatementTokens.FUNCTION);
            }
            return new FunctionEndStatement();
        }
        if (scanner.matchAdvance(StatementTokens.IF) != null) {
            ParseException ifneeded = scanner.expected(StatementTokens.IF);
            if (context.stack().getCurrentBlock().getType() != Stack.BlockKind.IF) {
                throw ifneeded;
            }
            return new IfEndStatement();
        }
        if (scanner.matchAdvance(StatementTokens.SUB) != null) {
            if (context.stack().getCurrentBlock().getType() != Stack.BlockKind.SUB) {
                throw scanner.expected(StatementTokens.SUB);
            }
            return new SubEndStatement();
        }
        return new ExitStatement(ExitStatement.ExitType.END);
    }
}

