/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.parse.StatementParser;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.statement.ExitStatement;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;

final class ExitParser
extends StatementParser {
    ExitParser() {
        super(true);
    }

    protected Statement parseStatement(Scanner scanner, ParseContext context) throws ParseException {
        if (scanner.matchAdvance(StatementTokens.EXIT) == null) {
            return null;
        }
        if (scanner.matchAdvance(StatementTokens.FOR) != null) {
            Stack.Block block = context.stack().findBlock(Stack.BlockKind.FOR);
            if (block == null) {
                throw scanner.expected(StatementTokens.FOR);
            }
            return new ExitStatement(ExitStatement.ExitType.FOR);
        }
        if (scanner.matchAdvance(StatementTokens.DO) != null) {
            Stack.Block block = context.stack().findBlock(Stack.BlockKind.DOWHILE);
            if (block == null) {
                throw scanner.expected(StatementTokens.DO);
            }
            return new ExitStatement(ExitStatement.ExitType.DO);
        }
        if (scanner.matchAdvance(StatementTokens.FUNCTION) == null && scanner.matchAdvance(StatementTokens.SUB) == null) {
            throw scanner.expected("Control block type");
        }
        return null;
    }
}

