/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.expression.Value;
import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.parse.BlockBuilder;
import com.nestor.interpret.jbasic.parse.StatementParser;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.statement.IfEndStatement;
import com.nestor.interpret.jbasic.statement.IfStatement;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.type.BOOLEAN;
import com.nestor.interpret.type.TYPES;

final class IfParser
extends StatementParser {
    IfParser() {
        super(false);
    }

    protected Statement parseStatement(Scanner scanner, ParseContext context) throws ParseException {
        if (scanner.matchAdvance(StatementTokens.IF) == null) {
            return null;
        }
        Value<BOOLEAN> cond = context.parseHelper().requireValue(scanner, TYPES.BOOLEAN_TYPE);
        scanner.required(StatementTokens.THEN);
        Stack stack = context.stack();
        stack.getClass();
        stack.new Stack.Block(Stack.BlockKind.IF);
        Statement consq = context.statementParser().parse(scanner, context);
        context.stack().blockEnd();
        if (super.isStatementValid(consq)) {
            return new IfStatement(cond, consq);
        }
        Statement body = this.nextBlock(scanner, context);
        IfStatement ifstat = new IfStatement(cond, body);
        while (scanner.matchAdvance(StatementTokens.ELSEIF) != null) {
            Value<BOOLEAN> alternative = context.parseHelper().requireValue(scanner, TYPES.BOOLEAN_TYPE);
            scanner.required(StatementTokens.THEN);
            Statement elseIfStatement = this.nextBlock(scanner, context);
            ifstat.addElseIfSatement(alternative, elseIfStatement);
        }
        if (scanner.matchAdvance(StatementTokens.ELSE) != null) {
            Stack stack2 = context.stack();
            stack2.getClass();
            stack2.new Stack.Block(Stack.BlockKind.IF);
            Statement elseStatement = context.parseHelper().requireStatementBlock(scanner, IfEndStatement.class);
            context.stack().blockEnd();
            ifstat.setElseSatement(elseStatement);
        }
        return ifstat;
    }

    private Statement nextBlock(Scanner scanner, ParseContext context) throws ParseException {
        Statement next;
        BlockBuilder loopBody = new BlockBuilder(true);
        Stack stack = context.stack();
        stack.getClass();
        stack.new Stack.Block(Stack.BlockKind.IF);
        do {
            next = context.statementParser().parse(scanner, context);
            loopBody.addStatement(next);
            if (IfEndStatement.class.isInstance(next)) break;
            if (next != null || !scanner.end()) continue;
            throw scanner.expected("Unexpected end of file");
        } while (next != null || scanner.match(StatementTokens.ELSE) == null && scanner.match(StatementTokens.ELSEIF) == null);
        context.stack().blockEnd();
        return loopBody.getStatementNonNull();
    }
}

