/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.expression.Value;
import com.nestor.interpret.expression.relational.RelationalTokens;
import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.Variable;
import com.nestor.interpret.jbasic.lang.VariableAccessor;
import com.nestor.interpret.jbasic.lang.VariableLookup;
import com.nestor.interpret.jbasic.parse.InterpretException;
import com.nestor.interpret.jbasic.parse.StatementParser;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.parse.SyntaxTokens;
import com.nestor.interpret.jbasic.statement.LetStatement;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.TYPE;
import com.nestor.interpret.type.TYPES;

final class LetParser
extends StatementParser {
    LetParser() {
        super(true);
    }

    protected Statement parseStatement(Scanner scanner, ParseContext context) throws ParseException, InterpretException {
        VariableAccessor var;
        Value<DATA> value;
        String let = scanner.matchAdvance(StatementTokens.LET);
        String identifier = scanner.match(SyntaxTokens.IDENTIFIER);
        if (identifier == null) {
            if (let == null) {
                return null;
            }
            throw scanner.expected(SyntaxTokens.IDENTIFIER);
        }
        scanner.advance();
        if (context.identify(identifier) == null) {
            scanner.required(RelationalTokens.EQUAL);
            value = context.parseHelper().requireValue(scanner, TYPES.DATA_TYPE);
            TYPE<DATA> valueType = value.getValueType();
            var = new VariableAccessor(VariableLookup.createLookup(context, identifier, valueType));
        } else {
            var = context.parseHelper().parseVariableAccess(scanner, identifier, Variable.DEFAULT_TYPE);
            scanner.required(RelationalTokens.EQUAL);
            value = context.parseHelper().requireValue(scanner, var.getValueType());
        }
        return new LetStatement(var, value);
    }
}

