/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.expression.DummyRuntimeEnv;
import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.jbasic.lang.DeclarationException;
import com.nestor.interpret.jbasic.lang.Parameter;
import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.UndeclaredIdentifierException;
import com.nestor.interpret.jbasic.lang.Variable;
import com.nestor.interpret.jbasic.lang.VariableAccessor;
import com.nestor.interpret.jbasic.lang.VariableLookup;
import com.nestor.interpret.jbasic.parse.BlockBuilder;
import com.nestor.interpret.jbasic.parse.ConstantValueParser;
import com.nestor.interpret.jbasic.parse.ExpressionValueParser;
import com.nestor.interpret.jbasic.parse.FunctionValueParser;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.parse.SyntaxTokens;
import com.nestor.interpret.jbasic.parse.VariableParser;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.parse.ChoiceParser;
import com.nestor.interpret.parse.Match;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Parser;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.token.StandardTokens;
import com.nestor.interpret.type.ARRAY_TYPE;
import com.nestor.interpret.type.ArrayQualifier;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.INTEGER;
import com.nestor.interpret.type.IndexRange;
import com.nestor.interpret.type.Qualifier;
import com.nestor.interpret.type.STRUCT_TYPE;
import com.nestor.interpret.type.StructQualifier;
import com.nestor.interpret.type.TYPE;
import com.nestor.interpret.type.TYPES;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParsingHelper {
    private final ParseContext context;

    public ParsingHelper(ParseContext context) {
        this.context = context;
    }

    public ArrayQualifier parseArrayQualifier(Scanner scanner, ARRAY_TYPE<? extends DATA> arType, Qualifier previous) throws ParseException {
        if (scanner.matchAdvance(StandardTokens.LP) == null) {
            return null;
        }
        ArrayList<Value<INTEGER>> indexList = new ArrayList<Value<INTEGER>>();
        Value<INTEGER> index = this.parseValue(scanner, TYPES.INTEGER_TYPE);
        if (index != null) {
            indexList.add(index);
            int i = 1;
            while (i < arType.getDimensions().size()) {
                scanner.required(StandardTokens.COMMA);
                indexList.add(this.requireValue(scanner, TYPES.INTEGER_TYPE));
                ++i;
            }
        }
        scanner.required(StandardTokens.RP);
        if (indexList.isEmpty()) {
            return null;
        }
        return new ArrayQualifier(arType, indexList, previous);
    }

    public <T extends DATA> T parseConstantValue(Scanner scanner, TYPE<T> type) throws ParseException {
        ChoiceParser<Value> valueParser = new ChoiceParser<Value>();
        valueParser.addParser(this.context.typeParser());
        ExpressionValueParser<T> expressionValueParser = new ExpressionValueParser<T>(type, (Parser<Value>)valueParser);
        Match value = expressionValueParser.parse(scanner, this.context);
        if (value == null) {
            return null;
        }
        DummyRuntimeEnv env = new DummyRuntimeEnv();
        try {
            return (T)value.evaluate(env);
        }
        catch (EvaluationException e) {
            throw scanner.parseFailure(e);
        }
    }

    public Qualifier parseQualifiers(Scanner scanner, TYPE<? extends DATA> typeFound) throws ParseException {
        TYPE<? extends DATA> currentType = typeFound;
        Qualifier currentQualifier = null;
        while (currentType.isQualifiable()) {
            Qualifier nextQualifier = null;
            if (currentType instanceof ARRAY_TYPE) {
                ARRAY_TYPE arType = (ARRAY_TYPE)currentType;
                nextQualifier = this.parseArrayQualifier(scanner, arType, currentQualifier);
            } else if (currentType instanceof STRUCT_TYPE) {
                nextQualifier = this.parseStructQualifier(scanner, (STRUCT_TYPE)currentType, currentQualifier);
            } else {
                throw new InternalError("not implemented for type " + currentType);
            }
            if (nextQualifier == null) {
                return currentQualifier;
            }
            currentQualifier = nextQualifier;
            currentType = currentQualifier.getQualifiedType();
        }
        return currentQualifier;
    }

    private Qualifier parseStructQualifier(Scanner scanner, STRUCT_TYPE structType, Qualifier previous) throws ParseException {
        if (scanner.matchAdvance(StandardTokens.DOT) == null) {
            return null;
        }
        String fieldName = scanner.required(SyntaxTokens.IDENTIFIER);
        if (structType.getFieldType(fieldName) == null) {
            throw scanner.expected("Qualifier for " + structType.describe());
        }
        return new StructQualifier(structType, fieldName, previous);
    }

    public <T extends DATA> Value<T> parseValue(Scanner scanner, TYPE<T> requestedType) throws ParseException {
        ChoiceParser<Value> valueParser = new ChoiceParser<Value>();
        valueParser.addParser(new FunctionValueParser(this.context));
        valueParser.addParser(new ConstantValueParser(this.context));
        valueParser.addParser(new VariableParser(this.context));
        valueParser.addParser(this.context.typeParser());
        ExpressionValueParser<T> expressionValueParser = new ExpressionValueParser<T>(requestedType, (Parser<Value>)valueParser);
        return expressionValueParser.parse(scanner, this.context);
    }

    public VariableAccessor parseVariableAccess(Scanner scanner, String identifier, TYPE<? extends DATA> defaultType) throws ParseException, DeclarationException {
        VariableLookup lookup = VariableLookup.createLookup(this.context, identifier, defaultType);
        TYPE<? extends DATA> valueType = lookup.getValueType();
        Qualifier qualifiers = null;
        if (valueType.isQualifiable()) {
            qualifiers = this.context.parseHelper().parseQualifiers(scanner, valueType);
        }
        return new VariableAccessor(lookup, qualifiers);
    }

    public <T extends DATA> T requireConstantValue(Scanner scanner, TYPE<T> type) throws ParseException {
        T constantValue = this.parseConstantValue(scanner, type);
        if (constantValue == null) {
            throw scanner.expected(type);
        }
        return constantValue;
    }

    public List<Value<? extends DATA>> requireParameterValueList(Scanner scanner, Collection<Parameter> parameters, boolean subCall) throws ParseException {
        boolean parenthesisRequired;
        if (this.context.getLangConstants().isParenthesisRequiredForCallableArgs()) {
            parenthesisRequired = true;
        } else if (subCall) {
            parenthesisRequired = false;
        } else {
            boolean bl = parenthesisRequired = parameters.size() > 0;
        }
        if (parenthesisRequired) {
            scanner.required(StandardTokens.LP);
        } else {
            parenthesisRequired = false;
        }
        LinkedList<Value<? extends DATA>> arguments = new LinkedList<Value<? extends DATA>>();
        int count = 1;
        for (Parameter param : parameters) {
            Value<? extends DATA> argument = this.requireValue(scanner, param.getType());
            if (count++ < parameters.size()) {
                scanner.required(StandardTokens.COMMA);
            }
            arguments.add(argument);
        }
        if (parenthesisRequired) {
            scanner.required(StandardTokens.RP);
        }
        return arguments;
    }

    public Statement requireStatementBlock(Scanner scanner, Class<? extends Statement> until) throws ParseException {
        BlockBuilder blockBody;
        block1: {
            Statement next;
            blockBody = new BlockBuilder(true);
            do {
                next = this.context.statementParser().parse(scanner, this.context);
                blockBody.addStatement(next);
                if (until.isInstance(next)) break block1;
                if (next != null || !scanner.end()) continue;
                throw scanner.expected("Unexpected end of file");
            } while (next != null);
            throw scanner.expected("statement");
        }
        return blockBody.getStatementNonNull();
    }

    private TYPE<? extends DATA> requireType(Scanner scanner) throws ParseException {
        TYPE<? extends DATA> type;
        String typeName = scanner.required(SyntaxTokens.IDENTIFIER, "type");
        try {
            type = this.context.moduleBuilder().getType(typeName);
        }
        catch (UndeclaredIdentifierException e) {
            throw scanner.parseFailure(e.getMessage());
        }
        if (type == null) {
            throw scanner.expected("type");
        }
        return type;
    }

    public TYPE<? extends DATA> requireTypeDeclaration(Scanner scanner) throws ParseException {
        ArrayList<IndexRange> dimensions = null;
        if (scanner.matchAdvance(StandardTokens.LP) != null) {
            int low = 0;
            int high = 0;
            dimensions = new ArrayList<IndexRange>();
            do {
                if (dimensions.size() > 0) {
                    high = this.requireConstantValue(scanner, TYPES.INTEGER_TYPE).intValue();
                } else {
                    INTEGER ihigh = this.parseConstantValue(scanner, TYPES.INTEGER_TYPE);
                    if (ihigh == null) {
                        dimensions.add(new IndexRange());
                        break;
                    }
                    high = ihigh.intValue();
                }
                low = 0;
                if (scanner.matchAdvance(StatementTokens.TO) != null) {
                    low = high;
                    high = this.requireConstantValue(scanner, TYPES.INTEGER_TYPE).intValue();
                }
                dimensions.add(new IndexRange(low, high));
            } while (scanner.matchAdvance(StandardTokens.COMMA) != null);
            scanner.required(StandardTokens.RP);
        }
        TYPE<DATA> variableType = scanner.matchAdvance(StatementTokens.AS) != null ? this.requireType(scanner) : Variable.DEFAULT_TYPE;
        if (dimensions == null) {
            return variableType;
        }
        return new ARRAY_TYPE<INTEGER>(dimensions, variableType);
    }

    public <T extends DATA> Value<T> requireValue(Scanner scanner, TYPE<T> requestedType) throws ParseException {
        Value<T> value = this.parseValue(scanner, requestedType);
        if (value == null) {
            throw scanner.expected(requestedType);
        }
        return value;
    }
}

