/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.lang.Variable;
import com.nestor.interpret.jbasic.parse.BlockBuilder;
import com.nestor.interpret.jbasic.parse.InterpretException;
import com.nestor.interpret.jbasic.parse.StatementParser;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.parse.VLAtLeastOne;
import com.nestor.interpret.jbasic.parse.VLRestrictedType;
import com.nestor.interpret.jbasic.parse.VariableList;
import com.nestor.interpret.jbasic.parse.VariableListParser;
import com.nestor.interpret.jbasic.statement.LocalDimStatement;
import com.nestor.interpret.jbasic.statement.RedimStatement;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.type.ARRAY_TYPE;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.TYPE;
import java.util.Map;

public final class RedimParser
extends StatementParser {
    public RedimParser() {
        super(true);
    }

    protected Statement parseStatement(Scanner scanner, ParseContext context) throws ParseException, InterpretException {
        if (scanner.matchAdvance(StatementTokens.REDIM) == null) {
            return null;
        }
        boolean global = context.stack().getCurrentBlock().getType() == Stack.BlockKind.TOPLEVEL;
        VLRestrictedType arraysOnly = new VLRestrictedType(new ARRAY_TYPE(), VLRestrictedType.Relation.SUPER_OR_EQUAL);
        VLAtLeastOne filter = new VLAtLeastOne(arraysOnly);
        VariableListParser varParser = new VariableListParser(context, filter);
        VariableList list = varParser.parse(scanner, context);
        BlockBuilder block = new BlockBuilder(false);
        for (Map.Entry<String, TYPE<? extends DATA>> entry : list.getVariables().entrySet()) {
            Variable var = null;
            String name = entry.getKey();
            if (context.stack().containsVariable(name)) {
                var = context.stack().getVariable(name);
            } else if (context.moduleBuilder().containsVariable(name)) {
                var = context.moduleBuilder().getVariable(name);
            }
            if (var != null) {
                ARRAY_TYPE varType = (ARRAY_TYPE)var.getValueType();
                ARRAY_TYPE newType = (ARRAY_TYPE)entry.getValue();
                varType.redim(newType.getDimensions());
                block.addStatement(new RedimStatement(name, newType));
                continue;
            }
            if (global) {
                context.moduleBuilder().addVariable(new Variable(name, entry.getValue()));
                continue;
            }
            context.stack().addVariable(new Variable(name, entry.getValue()));
            LocalDimStatement dimAsStatement = new LocalDimStatement(name, entry.getValue());
            block.addStatement(dimAsStatement);
        }
        return block.getStatementNonNull();
    }
}

