/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.parse.InterpretException;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.statement.NOP;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Parser;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.token.SimpleToken;
import com.nestor.interpret.token.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatementParser
implements Parser<Statement> {
    public static final Token EOL = new SimpleToken("End of line", "\n");
    public static final String STATEMENT_DESCRIPTION = "statement";
    private final boolean requiresEOLbyDefault;

    protected StatementParser(boolean requiresEOLbyDefault) {
        this.requiresEOLbyDefault = requiresEOLbyDefault;
    }

    @Override
    public String describe() {
        return STATEMENT_DESCRIPTION;
    }

    protected final boolean endOfStatementReached(Scanner scanner) throws ParseException {
        if (scanner.match(StatementTokens.COMMENT) != null) {
            return true;
        }
        return scanner.match(EOL) != null;
    }

    protected final boolean isStatementValid(Statement s) {
        return s != null && !(s instanceof NOP);
    }

    @Override
    public final Statement parse(Scanner scanner, ParseEnv env) throws ParseException {
        Statement statement;
        try {
            statement = this.parseStatement(scanner, (ParseContext)env);
        }
        catch (InterpretException e) {
            throw scanner.parseFailure(e);
        }
        if (statement == null) {
            return null;
        }
        if (this.requiresEOLbyDefault) {
            this.requireEOL(scanner);
        }
        return statement;
    }

    protected abstract Statement parseStatement(Scanner var1, ParseContext var2) throws ParseException, InterpretException;

    protected final void requireEOL(Scanner scanner) throws ParseException {
        scanner.matchAdvance(StatementTokens.COMMENT);
        scanner.required(EOL);
    }
}

