/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.parse;

import com.nestor.interpret.jbasic.lang.DeclarationException;
import com.nestor.interpret.jbasic.lang.ParseContext;
import com.nestor.interpret.jbasic.lang.RedeclarationException;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.parse.StatementParser;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.parse.SyntaxTokens;
import com.nestor.interpret.jbasic.statement.NOP;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.STRUCT_TYPE;
import com.nestor.interpret.type.TYPE;
import com.nestor.shared.Description;
import java.util.HashMap;

final class TypeParser
extends StatementParser {
    TypeParser() {
        super(true);
    }

    protected Statement parseStatement(Scanner scanner, ParseContext context) throws ParseException, DeclarationException {
        if (scanner.matchAdvance(StatementTokens.TYPE) == null) {
            return null;
        }
        if (context.stack().getCurrentBlock().getType() != Stack.BlockKind.TOPLEVEL) {
            throw scanner.parseFailure("Must be in top level block to declare types");
        }
        String typeName = scanner.required(SyntaxTokens.IDENTIFIER);
        Description identified = context.identify(typeName);
        if (identified != null) {
            scanner.parseFailure(new RedeclarationException(typeName, identified));
        }
        HashMap<String, TYPE<? extends DATA>> elements = new HashMap<String, TYPE<? extends DATA>>();
        super.requireEOL(scanner);
        while (scanner.matchAdvance(StatementTokens.END) == null) {
            String elementName = scanner.required(SyntaxTokens.IDENTIFIER);
            if (elements.containsKey(elementName)) {
                throw scanner.parseFailure("Duplicate identifier");
            }
            TYPE<? extends DATA> type = context.parseHelper().requireTypeDeclaration(scanner);
            super.requireEOL(scanner);
            elements.put(elementName, type);
        }
        scanner.required(StatementTokens.TYPE);
        STRUCT_TYPE newType = new STRUCT_TYPE(typeName, elements);
        context.moduleBuilder().addType(newType);
        return NOP.INSTANCE;
    }
}

