/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.statement;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.jbasic.lang.RuntimeContext;
import com.nestor.interpret.jbasic.lang.RuntimeStack;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.statement.ReturnCode;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.type.BOOLEAN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoWhileStatement
extends Statement {
    private static final long serialVersionUID = -9093497898091311255L;
    private final Statement loop;
    private final Value<BOOLEAN> condition;

    public DoWhileStatement(Statement loop, Value<BOOLEAN> condition) {
        this.loop = loop;
        this.condition = condition;
    }

    @Override
    public String describe() {
        if (this.condition == null) {
            return StatementTokens.DO.toString();
        }
        return StatementTokens.DO + " " + StatementTokens.WHILE + " " + this.condition.describe();
    }

    @Override
    protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
        ReturnCode rc = ReturnCode.SUCCESS;
        while (this.condition == null || this.condition.evaluate(context).booleanValue()) {
            RuntimeStack runtimeStack = context.stack();
            runtimeStack.getClass();
            runtimeStack.new Stack.Block(Stack.BlockKind.CODE);
            rc = this.loop.execute(context);
            context.stack().blockEnd();
            if (rc == ReturnCode.LOOP_DOWHILE) continue;
            if (rc == ReturnCode.EXIT_DO) break;
            if (rc == ReturnCode.SUCCESS) continue;
            return rc;
        }
        return ReturnCode.SUCCESS;
    }
}

