/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.statement;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.jbasic.lang.RuntimeContext;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.statement.ReturnCode;
import com.nestor.interpret.jbasic.statement.Statement;

public final class ExitStatement
extends Statement {
    private static final long serialVersionUID = 6108701303459801899L;
    private final ExitType type;

    public ExitStatement(ExitType type) {
        this.type = type;
    }

    protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
        switch (this.type) {
            case FOR: {
                return ReturnCode.EXIT_FOR;
            }
            case DO: {
                return ReturnCode.LOOP_DOWHILE;
            }
            case END: {
                return ReturnCode.END;
            }
        }
        throw new IllegalArgumentException("unknown exit");
    }

    public String describe() {
        if (this.type == ExitType.END) {
            return this.type.toString();
        }
        return StatementTokens.EXIT + " " + (Object)((Object)this.type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExitType {
        FOR,
        DO,
        END;

    }
}

