/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.statement;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.Expression;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.expression.arithmetic.ArithmeticOperator;
import com.nestor.interpret.expression.relational.RelationalExpression;
import com.nestor.interpret.expression.relational.RelationalOperator;
import com.nestor.interpret.expression.relational.RelationalTokens;
import com.nestor.interpret.jbasic.lang.RuntimeContext;
import com.nestor.interpret.jbasic.lang.RuntimeStack;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.lang.VariableAccessor;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.statement.ReturnCode;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.type.INTEGER;
import com.nestor.interpret.type.NUMBER;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ForStatement
extends Statement {
    private static final long serialVersionUID = 8292507149760421432L;
    private final Value<? extends NUMBER> from;
    private final Statement loop;
    private final Value<? extends NUMBER> step;
    private final Value<? extends NUMBER> to;
    private final VariableAccessor var;

    public ForStatement(Statement loop, VariableAccessor var, Value<? extends NUMBER> from, Value<? extends NUMBER> to, Value<? extends NUMBER> step) {
        this.loop = loop;
        this.var = var;
        this.from = from;
        this.to = to;
        this.step = step == null ? new INTEGER(1) : step;
    }

    @Override
    public String describe() {
        return StatementTokens.FOR + " " + this.var + RelationalTokens.EQUAL + this.from.describe() + " " + StatementTokens.TO + " " + this.to.describe() + " " + StatementTokens.STEP + " " + this.step.describe();
    }

    @Override
    protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
        Value<? extends NUMBER> init = this.from;
        this.var.setVariableValue(context, init.evaluate(context));
        VariableAccessor numVar = this.var;
        ArrayList<Value<? extends NUMBER>> adders = new ArrayList<Value<? extends NUMBER>>();
        adders.add(numVar);
        adders.add(this.step);
        Expression<NUMBER> add = new Expression<NUMBER>(ArithmeticOperator.ADDITION, adders);
        RelationalExpression cmp = new RelationalExpression(RelationalOperator.LESS_OR_EQUAL, numVar, this.to);
        ReturnCode rc = ReturnCode.SUCCESS;
        while (cmp.evaluate(context).booleanValue()) {
            RuntimeStack runtimeStack = context.stack();
            runtimeStack.getClass();
            runtimeStack.new Stack.Block(Stack.BlockKind.CODE);
            rc = this.loop.execute(context);
            context.stack().blockEnd();
            if (rc != ReturnCode.NEXT_FOR) {
                if (rc == ReturnCode.EXIT_FOR) break;
                if (rc != ReturnCode.SUCCESS) {
                    return rc;
                }
            }
            this.var.setVariableValue(context, add.evaluate(context));
        }
        return ReturnCode.SUCCESS;
    }
}

