/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.statement;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.Value;
import com.nestor.interpret.jbasic.lang.RuntimeContext;
import com.nestor.interpret.jbasic.lang.RuntimeStack;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.parse.StatementTokens;
import com.nestor.interpret.jbasic.statement.ReturnCode;
import com.nestor.interpret.jbasic.statement.Statement;
import com.nestor.interpret.type.BOOLEAN;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IfStatement
extends Statement {
    private static final long serialVersionUID = 8587550167494441602L;
    private final Value<BOOLEAN> condition;
    private final ArrayList<ElseIf> elses = new ArrayList();
    private Statement elseStatement = null;
    private final Statement mainStatement;

    public IfStatement(Value<BOOLEAN> condition, Statement body) {
        this.condition = condition;
        this.mainStatement = body;
    }

    public final void addElseIfSatement(Value<BOOLEAN> condition1, Statement elseIfStatement) {
        this.elses.add(new ElseIf(condition1, elseIfStatement));
    }

    @Override
    public String describe() {
        String res = StatementTokens.IF + this.condition.describe() + StatementTokens.THEN;
        res = String.valueOf(res) + this.mainStatement.describe();
        for (ElseIf elseIf : this.elses) {
            res = String.valueOf(res) + StatementTokens.ELSEIF + elseIf.condition.describe() + StatementTokens.THEN;
            res = String.valueOf(res) + elseIf.describe();
        }
        if (this.elseStatement != null) {
            res = String.valueOf(res) + StatementTokens.ELSE.describe();
            res = String.valueOf(res) + this.elseStatement.describe();
        }
        res = String.valueOf(res) + StatementTokens.END.describe() + " " + StatementTokens.IF.describe();
        return res;
    }

    @Override
    protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
        if (this.condition.evaluate(context).booleanValue()) {
            RuntimeStack runtimeStack = context.stack();
            runtimeStack.getClass();
            runtimeStack.new Stack.Block(Stack.BlockKind.CODE);
            ReturnCode code = this.mainStatement.execute(context);
            context.stack().blockEnd();
            return code;
        }
        for (ElseIf elseIf : this.elses) {
            if (!elseIf.condition.evaluate(context).booleanValue()) continue;
            return elseIf.execute(context);
        }
        if (this.elseStatement != null) {
            RuntimeStack runtimeStack = context.stack();
            runtimeStack.getClass();
            runtimeStack.new Stack.Block(Stack.BlockKind.CODE);
            ReturnCode code = this.elseStatement.execute(context);
            context.stack().blockEnd();
            return code;
        }
        return ReturnCode.SUCCESS;
    }

    public final void setElseSatement(Statement elseStatement) {
        this.elseStatement = elseStatement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElseIf
    extends Statement {
        private static final long serialVersionUID = -3068049927927598871L;
        final Value<BOOLEAN> condition;
        private final Statement statement;

        public ElseIf(Value<BOOLEAN> condition, Statement statement) {
            this.condition = condition;
            this.statement = statement;
        }

        @Override
        public String describe() {
            return this.statement.describe();
        }

        @Override
        protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
            RuntimeStack runtimeStack = context.stack();
            runtimeStack.getClass();
            runtimeStack.new Stack.Block(Stack.BlockKind.CODE);
            ReturnCode code = this.statement.execute(context);
            context.stack().blockEnd();
            return code;
        }
    }
}

