/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.jbasic.statement;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.jbasic.lang.RuntimeContext;
import com.nestor.interpret.jbasic.lang.RuntimeStack;
import com.nestor.interpret.jbasic.lang.Stack;
import com.nestor.interpret.jbasic.statement.NOP;
import com.nestor.interpret.jbasic.statement.ReturnCode;
import com.nestor.interpret.jbasic.statement.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatementBlock
extends Statement
implements Iterable<Statement> {
    private static final long serialVersionUID = 2249317006357650083L;
    private final ArrayList<Statement> statements = new ArrayList();
    private final boolean newBlock;

    public StatementBlock(boolean newBlock, Collection<Statement> statements) {
        this.newBlock = newBlock;
        this.statements.addAll(statements);
    }

    public StatementBlock(boolean newBlock, Statement ... statements) {
        this.newBlock = newBlock;
        Statement[] statementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            this.statements.add(statement);
            ++n2;
        }
    }

    public boolean add(Statement e) {
        if (e == NOP.INSTANCE || e == null) {
            return false;
        }
        if (e instanceof StatementBlock && !((StatementBlock)e).newBlock) {
            StatementBlock sb = (StatementBlock)e;
            boolean res = false;
            for (Statement statement : sb) {
                res |= this.add(statement);
            }
            return res;
        }
        this.statements.add(e);
        return true;
    }

    @Override
    public String describe() {
        return "statement";
    }

    @Override
    protected ReturnCode executeImpl(RuntimeContext context) throws EvaluationException {
        if (this.newBlock) {
            RuntimeStack runtimeStack = context.stack();
            runtimeStack.getClass();
            runtimeStack.new Stack.Block(Stack.BlockKind.CODE);
        }
        for (Statement statement : this.statements) {
            ReturnCode code = statement.execute(context);
            if (code == ReturnCode.SUCCESS) continue;
            if (this.newBlock) {
                context.stack().blockEnd();
            }
            return code;
        }
        if (this.newBlock) {
            context.stack().blockEnd();
        }
        return ReturnCode.SUCCESS;
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.statements.iterator();
    }
}

