/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.parse;

import com.nestor.interpret.parse.Match;
import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Parser;
import com.nestor.interpret.parse.Scanner;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChoiceParser<M extends Match>
implements Parser<M> {
    private final String customDescription;
    private final ArrayList<Parser<? extends M>> options = new ArrayList();

    public ChoiceParser() {
        this.customDescription = null;
    }

    public ChoiceParser(String customDescription) {
        this.customDescription = customDescription;
    }

    public void addParser(Parser<? extends M> parser) {
        this.options.add(parser);
    }

    @Override
    public final String describe() {
        if (this.customDescription != null) {
            return this.customDescription;
        }
        String res = "";
        boolean first = true;
        for (Parser<M> option : this.options) {
            if (!first) {
                res = String.valueOf(res) + " or ";
            } else {
                first = false;
            }
            res = String.valueOf(res) + option.toString();
        }
        return res;
    }

    @Override
    public final M parse(Scanner scanner, ParseEnv env) throws ParseException {
        for (Parser<M> parser : this.options) {
            M match = parser.parse(scanner, env);
            if (match == null) continue;
            return match;
        }
        return null;
    }
}

