/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.parse;

import com.nestor.interpret.parse.ParseEnv;
import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.parse.Skip;
import com.nestor.interpret.parse.WhitespaceSkip;
import com.nestor.interpret.token.Token;
import com.nestor.interpret.token.TokenContainer;
import com.nestor.shared.Description;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class LineScanner
extends Scanner {
    private StringBuilder lastSkip = new StringBuilder();
    private final Cursor position = new Cursor();
    private final BufferedReader reader;
    private final Skip skipPolicy;

    public LineScanner(ParseEnv env, Skip skipPolicy, TokenContainer tokens, Reader reader) {
        super(env, tokens);
        this.skipPolicy = skipPolicy;
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.nextLine();
    }

    public LineScanner(ParseEnv env, Skip skipPolicy, TokenContainer tokens, String input) {
        this(env, skipPolicy, tokens, new StringReader(input));
    }

    public LineScanner(ParseEnv env, TokenContainer tokens, Reader reader) {
        this(env, (Skip)new WhitespaceSkip(), tokens, reader);
    }

    public LineScanner(ParseEnv env, TokenContainer tokens, String input) {
        this(env, (Skip)new WhitespaceSkip(), tokens, new StringReader(input));
    }

    public Token advance() throws ParseException {
        block4: {
            if (this.getLastLexeme() == null) {
                return null;
            }
            this.position.offset += this.getLastLexeme().getLex().length();
            while (this.position.offset >= this.position.input.length()) {
                if (this.nextLine()) continue;
                this.terminate();
                return null;
            }
            this.lastSkip.delete(0, this.lastSkip.length());
            do {
                if (this.matchNextToken()) {
                    return this.getLastLexeme().getToken();
                }
                char nextChar = this.position.input.charAt(this.position.offset);
                if (!this.skipPolicy.skip(nextChar)) break block4;
                this.lastSkip.append(nextChar);
                ++this.position.offset;
            } while (this.position.offset < this.position.input.length() || this.nextLine());
            this.terminate();
            return null;
        }
        throw this.parseFailure("Unknown token");
    }

    protected Description getCurrentPositionDescription() {
        return this.position.clone();
    }

    public String getLastSkips() {
        return this.lastSkip.toString();
    }

    protected String matchToken(Token token) {
        if (this.position.offset >= this.position.input.length()) {
            return "eol";
        }
        return token.match(this.position.input, this.position.offset);
    }

    private boolean nextLine() {
        try {
            boolean next;
            String in = this.reader.readLine();
            boolean bl = next = in != null;
            if (next) {
                this.position.offset = 0;
                ++this.position.line;
                this.position.input = String.valueOf(in) + "\n";
            }
            return next;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString() {
        return this.reader.toString();
    }

    private class Cursor
    implements Description {
        String input;
        int line;
        int offset;

        public Cursor() {
        }

        private Cursor(int offset, int line, String input) {
            this.offset = offset;
            this.line = line;
            this.input = input;
        }

        public Description clone() {
            return new Cursor(this.offset, this.line, this.input);
        }

        public String describe() {
            Token token = LineScanner.this.findTokenAtCurrentPosition();
            String hint = null;
            if (token != null) {
                hint = LineScanner.this.matchToken(token);
            }
            if (hint == null && this.offset < this.input.length()) {
                hint = String.valueOf(this.input.charAt(this.offset));
            }
            String res = hint == null ? "At end of input, column " + this.offset + ", line " + this.line : "At '" + hint + "', column " + this.offset + ", line " + this.line;
            char[] shift = new char[this.offset];
            int i = 0;
            while (i < shift.length) {
                int c = this.input.charAt(i);
                shift[i] = Character.isWhitespace((char)c) ? c : 32;
                ++i;
            }
            return "\n" + this.input + new String(shift) + "^\n" + res;
        }
    }
}

