/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.token;

import com.nestor.interpret.parse.ParseException;
import com.nestor.interpret.parse.Scanner;
import com.nestor.interpret.token.Token;
import com.nestor.shared.Description;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiToken
implements Serializable,
Description {
    private static final long serialVersionUID = -2638205124930227220L;
    private final Collection<Token> tokens;

    public MultiToken(Collection<Token> options) {
        this.tokens = options;
    }

    public MultiToken(Token ... options) {
        this.tokens = Arrays.asList(options);
    }

    @Override
    public String describe() {
        String res = "{ ";
        boolean first = true;
        for (Token token : this.tokens) {
            if (first) {
                res = String.valueOf(res) + token.describe();
                first = false;
                continue;
            }
            res = String.valueOf(res) + " | " + token.describe();
        }
        return String.valueOf(res) + " }";
    }

    public Collection<Token> getTokens() {
        return this.tokens;
    }

    public Token match(Scanner scanner) throws ParseException {
        for (Token token : this.tokens) {
            if (scanner.match(token) == null) continue;
            return token;
        }
        return null;
    }

    public Token matchAdvance(Scanner scanner) throws ParseException {
        for (Token token : this.tokens) {
            if (scanner.matchAdvance(token) == null) continue;
            return token;
        }
        return null;
    }

    public Token required(Scanner scanner) throws ParseException {
        ParseException exception = scanner.parseFailure(this.describe());
        for (Token token : this.tokens) {
            if (scanner.matchAdvance(token) == null) continue;
            return token;
        }
        throw exception;
    }
}

