/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.token;

import com.nestor.interpret.token.SimpleToken;
import com.nestor.interpret.token.Token;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexToken
implements Token {
    private final Pattern pattern;
    private final String description;

    public RegexToken(String regex) {
        this.description = null;
        this.pattern = Pattern.compile(regex, 2);
    }

    public RegexToken(String description, String regex) {
        this.description = description;
        this.pattern = Pattern.compile(regex, 2);
    }

    public RegexToken(String regex, boolean caseSensitive) {
        this.description = null;
        this.pattern = !caseSensitive ? Pattern.compile(regex, 2) : Pattern.compile(regex);
    }

    public RegexToken(String description, String regex, boolean caseSensitive) {
        this.description = description;
        this.pattern = !caseSensitive ? Pattern.compile(regex, 2) : Pattern.compile(regex);
    }

    public final String match(String input, int offset) {
        Matcher matcher = this.pattern.matcher(input.substring(offset));
        if (matcher.lookingAt()) {
            return matcher.group();
        }
        return null;
    }

    public final boolean isSame(Token obj) {
        if (obj instanceof RegexToken) {
            return ((RegexToken)obj).pattern.pattern().equals(this.pattern.pattern());
        }
        return false;
    }

    public String describe() {
        if (this.description != null) {
            return this.description;
        }
        return this.pattern.toString();
    }

    public final boolean isShadowing(Token other) {
        if (other instanceof SimpleToken) {
            SimpleToken st = (SimpleToken)other;
            Matcher matcher = this.pattern.matcher(st.getLex());
            return matcher.matches();
        }
        if (other instanceof RegexToken) {
            RegexToken rt = (RegexToken)other;
            return rt.pattern.pattern().indexOf(this.pattern.pattern()) == 0;
        }
        return false;
    }

    public String toString() {
        return this.describe();
    }
}

