/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.token;

import com.nestor.interpret.token.MultiToken;
import com.nestor.interpret.token.Token;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenContainer
implements Iterable<Token> {
    private ArrayList<Token> tokens = new ArrayList();

    private static ArrayList<Token> extractTokens(Class fromClass) {
        Field[] fields = fromClass.getFields();
        ArrayList<Token> tokens = new ArrayList<Token>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            boolean assignableFrom = Token.class.isAssignableFrom(field.getType());
            if (assignableFrom && Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers)) {
                try {
                    tokens.add((Token)field.get(null));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return tokens;
    }

    public synchronized void addToken(Token token) {
        for (Token t : this.tokens) {
            if (!t.isShadowing(token)) continue;
            throw new IllegalArgumentException("Token '" + t.describe() + "' is shadowing the new token '" + token.describe() + "'");
        }
        this.tokens.add(token);
    }

    public synchronized void addTokens(Class fromUtilityClass) {
        this.addTokens(TokenContainer.extractTokens(fromUtilityClass));
    }

    public synchronized void addTokens(Iterable<Token> tokens1) {
        for (Token token : tokens1) {
            this.addToken(token);
        }
    }

    public synchronized void addTokens(MultiToken tokens1) {
        this.addTokens(tokens1.getTokens());
    }

    public synchronized void addTokens(Token ... tokens1) {
        Token[] tokenArray = tokens1;
        int n = tokens1.length;
        int n2 = 0;
        while (n2 < n) {
            Token token = tokenArray[n2];
            this.addToken(token);
            ++n2;
        }
    }

    public synchronized boolean contains(Token token) {
        for (Token t : this.tokens) {
            if (!t.isSame(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Token> iterator() {
        return this.tokens.iterator();
    }
}

