/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.type;

import com.nestor.interpret.expression.EvaluationException;
import com.nestor.interpret.expression.RuntimeEnv;
import com.nestor.interpret.type.ChainQualifier;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.Qualifier;
import com.nestor.interpret.type.STRUCT;
import com.nestor.interpret.type.STRUCT_TYPE;
import com.nestor.interpret.type.TYPE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StructQualifier
extends ChainQualifier<STRUCT> {
    private static final long serialVersionUID = 1078988802944935701L;
    private final String fieldName;
    private final STRUCT_TYPE structType;

    public StructQualifier(STRUCT_TYPE structType, String fieldName, Qualifier chained) {
        super(chained);
        if (structType.getFieldType(fieldName) == null) {
            throw new IllegalArgumentException("Invalid qualfier");
        }
        this.structType = structType;
        this.fieldName = fieldName;
    }

    @Override
    public String describe() {
        return this.fieldName;
    }

    @Override
    protected DATA getChained(RuntimeEnv env, STRUCT unqualified) throws EvaluationException {
        return unqualified.getField(this.fieldName);
    }

    @Override
    public TYPE<? extends DATA> getQualifiedType() {
        return this.structType.getFieldType(this.fieldName);
    }

    @Override
    protected void setChained(RuntimeEnv env, STRUCT unqualified, DATA data) throws EvaluationException {
        unqualified.setField(this.fieldName, data);
    }
}

