/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.interpret.type;

import com.nestor.interpret.type.BOOLEAN;
import com.nestor.interpret.type.DATA;
import com.nestor.interpret.type.DATA_TYPE;
import com.nestor.interpret.type.DOUBLE;
import com.nestor.interpret.type.INTEGER;
import com.nestor.interpret.type.NUMBER;
import com.nestor.interpret.type.PRIMITIVE;
import com.nestor.interpret.type.SIMPLE_TYPE;
import com.nestor.interpret.type.STRING;
import com.nestor.interpret.type.TYPE;

public final class TYPES {
    public static final TYPE<BOOLEAN> BOOLEAN_TYPE = new SIMPLE_TYPE<BOOLEAN>(BOOLEAN.class);
    public static final TYPE<DATA> DATA_TYPE = new DATA_TYPE<DATA>();
    public static final TYPE<DOUBLE> DOUBLE_TYPE = new SIMPLE_TYPE<DOUBLE>(DOUBLE.class){
        private static final long serialVersionUID = 2821972995402948186L;

        @Override
        public boolean canPromote(TYPE toType) {
            return INTEGER_TYPE.areEqual(toType);
        }

        @Override
        public <P extends DATA> P promote(DOUBLE value, TYPE<P> toType) {
            if (INTEGER_TYPE.areEqual(toType)) {
                return (P)new INTEGER(value.intValue());
            }
            return null;
        }
    };
    public static final TYPE<INTEGER> INTEGER_TYPE = new SIMPLE_TYPE<INTEGER>(INTEGER.class){
        private static final long serialVersionUID = -4185086311021619955L;

        @Override
        public boolean canPromote(TYPE toType) {
            return DOUBLE_TYPE.areEqual(toType);
        }

        @Override
        public <P extends DATA> P promote(INTEGER value, TYPE<P> toType) {
            if (DOUBLE_TYPE.areEqual(toType)) {
                return (P)new DOUBLE(value.doubleValue());
            }
            return null;
        }
    };
    public static final TYPE<NUMBER> NUMBER_TYPE = new SIMPLE_TYPE<NUMBER>(NUMBER.class);
    public static final TYPE<PRIMITIVE> PRIMITIVE_TYPE = new SIMPLE_TYPE<PRIMITIVE>(PRIMITIVE.class);
    public static final TYPE<STRING> STRING_TYPE = new SIMPLE_TYPE<STRING>(STRING.class);

    private TYPES() {
    }
}

