/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.shared.event;

import com.nestor.shared.event.InvocationIterator;
import com.nestor.shared.util.ImmutableList;
import com.nestor.shared.util.PassiveIterator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPublisher {
    private ImmutableList<Object> rootNode = null;
    private WeakHashMap<Class, Object> proxyCache = new WeakHashMap();

    public synchronized void add(Object listener) {
        this.rootNode = new ImmutableList<Object>(this.rootNode, listener);
    }

    public synchronized <T> T cast(Class<T> theInterface) {
        Object castType = this.proxyCache.get(theInterface);
        if (castType == null) {
            castType = Proxy.newProxyInstance(theInterface.getClassLoader(), new Class[]{theInterface}, this.createInvocationHandler(theInterface));
            this.proxyCache.put(theInterface, castType);
        }
        return (T)castType;
    }

    private <T> InvocationHandler createInvocationHandler(final Class<T> theInterface) {
        return new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                MultiPublisher.this.publish(theInterface, new InvocationIterator(method, args));
                return null;
            }
        };
    }

    public <T> void publish(final Class<T> lClass, final PassiveIterator<T> iterator) {
        ImmutableList<Object> node = this.rootNode;
        if (node != null) {
            PassiveIterator<Object> invocationIterator = new PassiveIterator<Object>(){

                @Override
                public void next(Object n) {
                    if (n != null && lClass.isAssignableFrom(n.getClass())) {
                        iterator.next(n);
                    }
                }
            };
            node.traverse(invocationIterator);
        }
    }

    public synchronized void remove(Object listener) {
        if (this.rootNode != null) {
            this.rootNode = this.rootNode.remove(listener);
        }
    }

    public synchronized void removeAll() {
        this.rootNode = null;
    }
}

