/*
 * Decompiled with CFR 0.152.
 */
package com.nestor.shared.util;

import com.nestor.shared.util.Node;
import com.nestor.shared.util.PassiveIterator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetNode<T>
implements Node<T> {
    private T content;
    private Map<T, Node<T>> subnodes = null;

    public NetNode(T content) {
        this.content = content;
    }

    @Override
    public void append(Node<T> subNode) {
        if (this.subnodes == null) {
            this.subnodes = new HashMap<T, Node<T>>();
        }
        this.subnodes.put(subNode.get(), subNode);
    }

    @Override
    public T get() {
        return this.content;
    }

    @Override
    public void traverse(PassiveIterator<T> v, Node.TraverseDirection td) {
        Node.TraverseDirection traverseSubDir = td;
        if (traverseSubDir == Node.TraverseDirection.DEFAULT) {
            traverseSubDir = Node.TraverseDirection.TOP_DOWN;
        }
        if (traverseSubDir == Node.TraverseDirection.TOP_DOWN) {
            v.next(this.content);
        }
        if (this.subnodes != null) {
            for (Node<T> subnode : this.subnodes.values()) {
                subnode.traverse(v, traverseSubDir);
            }
        }
        if (traverseSubDir != Node.TraverseDirection.TOP_DOWN) {
            v.next(this.content);
        }
    }
}

